/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\bH\u0007R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager;", "T", "Lcom/intellij/openapi/client/ClientSession;", "", "<init>", "()V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/codeWithMe/ClientId;", "getSessions", "", "kind", "Lcom/intellij/openapi/client/ClientKind;", "getSession", "clientId", "(Lcom/intellij/codeWithMe/ClientId;)Lcom/intellij/openapi/client/ClientSession;", "registerSession", "", "disposable", "Lcom/intellij/openapi/Disposable;", "session", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/client/ClientSession;)V", "isValid", "", "Companion", "intellij.platform.core"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n774#2:98\n865#2,2:99\n61#3,5:101\n61#3,5:106\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n*L\n69#1:98\n69#1:99,2\n82#1:101,5\n87#1:106,5\n*E\n"})
public class ClientSessionsManager<T extends ClientSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<ClientId, T> sessions = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getSessions(@NotNull ClientKind kind) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (kind == ClientKind.ALL) {
            return new ArrayList<T>(this.sessions.values());
        }
        Collection<T> collection = this.sessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl = false;
            if (!it.getType().matches(kind)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final T getSession(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        return (T)((ClientSession)this.sessions.get(clientId));
    }

    public final void registerSession(@NotNull Disposable disposable, @NotNull T session) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(session, (String)"session");
        ClientId clientId = session.getClientId();
        if (this.sessions.putIfAbsent(clientId, session) != null) {
            ClientSessionsManagerKt.access$getLOG$p().error("Session " + session + " with such clientId is already registered");
        }
        Logger $this$debug_u24default$iv = ClientSessionsManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Session added '" + session + '\'', e$iv);
        }
        Disposer.register(disposable, (Disposable)session);
        Disposer.register(disposable, () -> ClientSessionsManager.registerSession$lambda$3(this, clientId));
    }

    @Deprecated(message="Use `!session.isDisposed` instead or better run coroutine from per-client scope that will be cancelled when a client has gone", replaceWith=@ReplaceWith(expression="!session.isDisposed", imports={}), level=DeprecationLevel.ERROR)
    @ApiStatus.Obsolete
    public final boolean isValid(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        T t = this.getSession(clientId);
        return t != null ? !((ComponentManager)t).isDisposed() : false;
    }

    private static final void registerSession$lambda$3(ClientSessionsManager this$0, ClientId $clientId) {
        this$0.sessions.remove($clientId);
        Logger $this$debug_u24default$iv = ClientSessionsManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Session removed '" + $clientId + '\'', e$iv);
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession(@NotNull ClientId clientId) {
        return Companion.getAppSession(clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
        return Companion.getAppSessions(kind);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
        return Companion.getProjectSession(project, clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
        return Companion.getProjectSessions(project, kind);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientAppSession getAppSession() {
        return Companion.getAppSession();
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project) {
        return Companion.getProjectSession(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager$Companion;", "", "<init>", "()V", "getAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "getAppSessions", "", "kind", "Lcom/intellij/openapi/client/ClientKind;", "getProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProjectSessions", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n31#2,2:100\n31#2,2:102\n31#2,2:104\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n*L\n28#1:98,2\n38#1:100,2\n48#1:102,2\n58#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession(@NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Application application = ApplicationManager.getApplication();
            Object object = application;
            if (application == null) return null;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            object = clientSessionsManager;
            if (clientSessionsManager == null) return null;
            ClientAppSession clientAppSession = (ClientAppSession)((ClientSessionsManager)object).getSession(clientId);
            return clientAppSession;
        }

        public static /* synthetic */ ClientAppSession getAppSession$default(Companion companion, ClientId clientId, int n, Object object) {
            if ((n & 1) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getAppSession(clientId);
        }

        @JvmStatic
        @NotNull
        public final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
                    object = ApplicationManager.getApplication();
                    if (object == null) break block4;
                    ComponentManager $this$service$iv = (ComponentManager)object;
                    boolean $i$f$service = false;
                    Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
                    ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
                    if (clientSessionsManager == null) {
                        throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
                    }
                    object = clientSessionsManager;
                    if (clientSessionsManager != null && (object = ((ClientSessionsManager)object).getSessions(kind)) != null) break block5;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            return (ClientProjectSession)clientSessionsManager.getSession(clientId);
        }

        public static /* synthetic */ ClientProjectSession getProjectSession$default(Companion companion, Project project, ClientId clientId, int n, Object object) {
            if ((n & 2) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.getProjectSession(project, clientId);
        }

        @JvmStatic
        @NotNull
        public final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            ClientSessionsManager clientSessionsManager = $this$service$iv.getService(serviceClass$iv);
            if (clientSessionsManager == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            return clientSessionsManager.getSessions(kind);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientAppSession getAppSession() {
            return com.intellij.openapi.client.ClientSessionsManager$Companion.getAppSession$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return com.intellij.openapi.client.ClientSessionsManager$Companion.getProjectSession$default(this, project, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

