/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointNameKt;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.AdapterWithCustomAttributes;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u001c\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/openapi/extensions/LazyExtensionImpl;", "T", "", "Lcom/intellij/openapi/extensions/LazyExtension;", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "point", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "<init>", "(Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;)V", "id", "", "getId", "()Ljava/lang/String;", "order", "Lcom/intellij/openapi/extensions/LoadingOrder;", "getOrder", "()Lcom/intellij/openapi/extensions/LoadingOrder;", "getCustomAttribute", "name", "instance", "getInstance", "()Ljava/lang/Object;", "implementationClassName", "getImplementationClassName", "implementationClass", "Ljava/lang/Class;", "getImplementationClass", "()Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginDescriptor", "()Lcom/intellij/openapi/extensions/PluginDescriptor;", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nExtensionPointName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointName.kt\ncom/intellij/openapi/extensions/LazyExtensionImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,355:1\n14#2:356\n*S KotlinDebug\n*F\n+ 1 ExtensionPointName.kt\ncom/intellij/openapi/extensions/LazyExtensionImpl\n*L\n335#1:356\n*E\n"})
final class LazyExtensionImpl<T>
implements LazyExtension<T> {
    @JvmField
    @NotNull
    public final ExtensionComponentAdapter adapter;
    @JvmField
    @NotNull
    public final ExtensionPointImpl<T> point;

    public LazyExtensionImpl(@NotNull ExtensionComponentAdapter adapter, @NotNull ExtensionPointImpl<T> point) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(point, (String)"point");
        this.adapter = adapter;
        this.point = point;
    }

    @Override
    @Nullable
    public String getId() {
        return this.adapter.getOrderId();
    }

    @Override
    @NotNull
    public LoadingOrder getOrder() {
        return this.adapter.getOrder();
    }

    @Override
    @Nullable
    public String getCustomAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.adapter instanceof AdapterWithCustomAttributes ? ((AdapterWithCustomAttributes)this.adapter).customAttributes.get(name) : null;
    }

    @Override
    @Nullable
    public T getInstance() {
        return (T)ExtensionPointNameKt.access$createOrError(this.adapter, this.point);
    }

    @Override
    @NotNull
    public String getImplementationClassName() {
        return this.adapter.getAssignableToClassName();
    }

    @Override
    @Nullable
    public Class<T> getImplementationClass() {
        try {
            return this.adapter.getImplementationClass(this.point.componentManager);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ExtensionPointName.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(this.point.componentManager.createError(e, this.adapter.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    @Override
    @NotNull
    public PluginDescriptor getPluginDescriptor() {
        return this.adapter.pluginDescriptor;
    }
}

