/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            MessageBusConnection connection;
            ExtensionPoint extensionPoint = app.getExtensionArea().getExtensionPointIfRegistered(VirtualFileSystem.EP_NAME.getName());
            if (extensionPoint != null) {
                Disposable extensionDisposable = ExtensionPointUtil.createExtensionDisposable(this, extensionPoint, ep -> ep.getKey().equals(this.getProtocol()));
                connection = app.getMessageBus().connect(extensionDisposable);
            } else {
                connection = app.getMessageBus().connect();
            }
            connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myEventDispatcher.getMulticaster(), this));
        }
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher.addListener(listener);
    }

    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.removeListener(listener);
    }

    protected void firePropertyChanged(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(2);
        }
        if (propertyName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(3);
        }
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        this.myEventDispatcher.getMulticaster().propertyChanged(event);
    }

    protected void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(4);
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), oldModificationStamp, file.getModificationStamp());
        this.myEventDispatcher.getMulticaster().contentsChanged(event);
    }

    protected void fireFileCreated(@Nullable Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(5);
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().fileCreated(event);
    }

    protected void fireFileDeleted(Object requestor, @NotNull VirtualFile file, @NotNull String fileName, VirtualFile parent) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(7);
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, parent, 0L, 0L);
        this.myEventDispatcher.getMulticaster().fileDeleted(event);
    }

    protected void fireFileMoved(Object requestor, @NotNull VirtualFile file, VirtualFile oldParent) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(8);
        }
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, oldParent, file.getParent());
        this.myEventDispatcher.getMulticaster().fileMoved(event);
    }

    protected void fireFileCopied(@Nullable Object requestor, @NotNull VirtualFile originalFile, @NotNull VirtualFile createdFile) {
        if (originalFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(9);
        }
        if (createdFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(10);
        }
        this.assertWriteAccessAllowed();
        VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
        this.myEventDispatcher.getMulticaster().fileCopied(event);
    }

    protected void fireBeforePropertyChange(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(11);
        }
        if (propertyName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(12);
        }
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        this.myEventDispatcher.getMulticaster().beforePropertyChange(event);
    }

    protected void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(13);
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().beforeContentsChange(event);
    }

    protected void fireBeforeFileDeletion(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(14);
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().beforeFileDeletion(event);
    }

    protected void fireBeforeFileMovement(Object requestor, @NotNull VirtualFile file, VirtualFile newParent) {
        if (file == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(15);
        }
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, file.getParent(), newParent);
        this.myEventDispatcher.getMulticaster().beforeFileMovement(event);
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(16);
        }
        throw this.unsupported("deleteFile", vFile);
    }

    @Override
    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(17);
        }
        if (newParent == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(18);
        }
        throw this.unsupported("move", vFile);
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(20);
        }
        throw this.unsupported("renameFile", vFile);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(21);
        }
        if (fileName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(22);
        }
        throw this.unsupported("createChildFile", vDir);
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(23);
        }
        if (dirName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(24);
        }
        throw this.unsupported("createChildDirectory", vDir);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(25);
        }
        if (newParent == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(26);
        }
        if (copyName == null) {
            DeprecatedVirtualFileSystem.$$$reportNull$$$0(27);
        }
        throw this.unsupported("copyFile", vFile);
    }

    private UnsupportedOperationException unsupported(String op, VirtualFile vFile) {
        return new UnsupportedOperationException(op + '(' + vFile + ") not supported by " + this.getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "firePropertyChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireContentsChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fireFileCreated";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fireFileDeleted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fireFileMoved";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fireFileCopied";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforePropertyChange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeContentsChange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeFileDeletion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeFileMovement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "moveFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "renameFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createChildFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createChildDirectory";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

