/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.coroutines.sync;

import com.intellij.platform.util.coroutines.sync.DropOldestSemaphoreBase;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/util/coroutines/sync/DropOldestSemaphore;", "Lcom/intellij/platform/util/coroutines/sync/DropOldestSemaphoreBase;", "permits", "", "<init>", "(I)V", "_activeJobs", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/collections/immutable/PersistentSet;", "Lkotlinx/coroutines/Job;", "kotlin.jvm.PlatformType", "publishCurrentJob", "currentJob", "removeCurrentJob", "", "intellij.platform.util.coroutines"})
final class DropOldestSemaphore
extends DropOldestSemaphoreBase {
    private final int permits;
    @NotNull
    private final AtomicReference<PersistentSet<Job>> _activeJobs;

    public DropOldestSemaphore(int permits) {
        super(permits);
        this.permits = permits;
        this._activeJobs = new AtomicReference(ExtensionsKt.persistentSetOf());
    }

    @Override
    @Nullable
    protected Job publishCurrentJob(@NotNull Job currentJob) {
        Job oldestJob;
        Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
        while (true) {
            PersistentSet<Job> activeJobs;
            if ((activeJobs = this._activeJobs.get()).size() < this.permits) {
                PersistentSet<Job> newJobs = activeJobs.add(currentJob);
                if (!this._activeJobs.compareAndSet(activeJobs, newJobs)) continue;
                return null;
            }
            Intrinsics.checkNotNull(activeJobs);
            oldestJob = (Job)CollectionsKt.first((Iterable)activeJobs);
            PersistentSet<Job> newJobs = activeJobs.remove(oldestJob).add(currentJob);
            if (this._activeJobs.compareAndSet(activeJobs, newJobs)) break;
        }
        return oldestJob;
    }

    @Override
    protected void removeCurrentJob(@NotNull Job currentJob) {
        PersistentSet<Job> newJobs;
        PersistentSet<Job> activeJobs;
        Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
        do {
            if ((newJobs = (activeJobs = this._activeJobs.get()).remove(currentJob)) != activeJobs) continue;
            return;
        } while (!this._activeJobs.compareAndSet(activeJobs, newJobs));
    }
}

