/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.cache;

import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.cache.EntityStorageChange;
import com.intellij.platform.workspace.storage.impl.query.MatchList;
import com.intellij.platform.workspace.storage.impl.query.MatchWithEntityId;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.trace.TracingKt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange;", "Lcom/intellij/platform/workspace/storage/impl/cache/EntityStorageChange;", "changes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/platform/workspace/storage/EntityChange;", "<init>", "(Lkotlin/sequences/Sequence;)V", "size", "", "getSize", "()I", "createTraces", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "Lcom/intellij/platform/workspace/storage/trace/ReadTraceHashSet;", "snapshot", "Lcom/intellij/platform/workspace/storage/instrumentation/ImmutableEntityStorageInstrumentation;", "createTraces$intellij_platform_workspace_storage", "makeTokensForDiff", "Lcom/intellij/platform/workspace/storage/impl/query/MatchList;", "makeTokensForDiff$intellij_platform_workspace_storage", "intellij.platform.workspace.storage"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTracedSnapshotCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,240:1\n1317#2,2:241\n*S KotlinDebug\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange\n*L\n144#1:241,2\n*E\n"})
public final class ChangeOnVersionedChange
implements EntityStorageChange {
    @NotNull
    private final Sequence<EntityChange<?>> changes;

    public ChangeOnVersionedChange(@NotNull Sequence<? extends EntityChange<?>> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.changes = changes;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @NotNull
    public final LongOpenHashSet createTraces$intellij_platform_workspace_storage(@NotNull ImmutableEntityStorageInstrumentation snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return TracingKt.toTraces(this.changes, snapshot);
    }

    @NotNull
    public final MatchList makeTokensForDiff$intellij_platform_workspace_storage() {
        MatchList matchList = new MatchList();
        LongOpenHashSet createdAddTokens = new LongOpenHashSet();
        LongOpenHashSet createdRemovedTokens = new LongOpenHashSet();
        Sequence<EntityChange<?>> $this$forEach$iv = this.changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long l;
            EntityChange change = (EntityChange)element$iv;
            boolean bl = false;
            Object object = change.getNewEntity();
            if (object != null && (object = UtilsKt.asBase(object)) != null) {
                l = ((WorkspaceEntityBase)object).getId();
            } else {
                Object object2 = change.getOldEntity();
                Long l2 = object2 != null && (object2 = UtilsKt.asBase(object2)) != null ? Long.valueOf(((WorkspaceEntityBase)object2).getId()) : null;
                Intrinsics.checkNotNull(l2);
                l = l2;
            }
            long entityId = l;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                if (!createdAddTokens.add(entityId)) continue;
                matchList.addedMatch(new MatchWithEntityId(entityId, null));
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                if (!createdRemovedTokens.add(entityId)) continue;
                matchList.removedMatch(new MatchWithEntityId(entityId, null));
                continue;
            }
            if (entityChange instanceof EntityChange.Replaced) {
                if (createdRemovedTokens.add(entityId)) {
                    matchList.removedMatch(new MatchWithEntityId(entityId, null));
                }
                if (!createdAddTokens.add(entityId)) continue;
                matchList.addedMatch(new MatchWithEntityId(entityId, null));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return matchList;
    }
}

