/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider
implements PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(PsiAugmentProvider.class);
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");
    @NotNull
    private static final NotNullLazyValue<ExtensionPoint<PsiAugmentProvider>> EP = NotNullLazyValue.lazy(() -> EP_NAME.getPoint());
    private final Key<CachedValue<Map<Class, List>>> myCacheKey = Key.create(this.getClass().getName());

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type, @Nullable String nameHint) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PsiAugmentProvider.$$$reportNull$$$0(1);
        }
        if (nameHint == null) {
            List<Psi> list = this.getAugments(element, type);
            if (list == null) {
                PsiAugmentProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Map cache2 = (Map)CachedValuesManager.getCachedValue(element, this.myCacheKey, () -> {
            ConcurrentMap<Class, List> map2 = ConcurrentFactoryMap.createMap(c -> this.getAugments(element, (Class)c));
            return CachedValueProvider.Result.create(map2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        List list = (List)cache2.get(type);
        if (list == null) {
            PsiAugmentProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @ApiStatus.Experimental
    protected List<PsiExtensionMethod> getExtensionMethods(@NotNull PsiClass aClass, @NotNull String nameHint, @NotNull PsiElement context) {
        if (aClass == null) {
            PsiAugmentProvider.$$$reportNull$$$0(4);
        }
        if (nameHint == null) {
            PsiAugmentProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PsiAugmentProvider.$$$reportNull$$$0(6);
        }
        return Collections.emptyList();
    }

    @Deprecated
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(7);
        }
        if (type == null) {
            PsiAugmentProvider.$$$reportNull$$$0(8);
        }
        List list = Collections.emptyList();
        if (list == null) {
            PsiAugmentProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(10);
        }
        return null;
    }

    protected boolean canInferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(11);
        }
        return this.inferType(typeElement) != null;
    }

    protected boolean fieldInitializerMightBeChanged(@NotNull PsiField field) {
        if (field == null) {
            PsiAugmentProvider.$$$reportNull$$$0(12);
        }
        return false;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(13);
        }
        if (modifiers == null) {
            PsiAugmentProvider.$$$reportNull$$$0(14);
        }
        Set<String> set = modifiers;
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type, @Nullable String nameHint) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(16);
        }
        if (type == null) {
            PsiAugmentProvider.$$$reportNull$$$0(17);
        }
        SmartList result2 = new SmartList();
        PsiAugmentProvider.forEach(element.getProject(), provider -> {
            List augments = provider.getAugments(element, type, nameHint);
            for (PsiElement augment : augments) {
                if (nameHint != null && augment instanceof PsiNamedElement && !nameHint.equals(((PsiNamedElement)augment).getName())) continue;
                try {
                    PsiUtilCore.ensureValid(augment);
                    result2.add(augment);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(PluginException.createByClass(e, provider.getClass()));
                }
            }
            return true;
        });
        SmartList smartList = result2;
        if (smartList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<PsiExtensionMethod> collectExtensionMethods(PsiClass aClass, @NotNull String nameHint, PsiElement context) {
        if (nameHint == null) {
            PsiAugmentProvider.$$$reportNull$$$0(19);
        }
        SmartList<PsiExtensionMethod> extensionMethods = new SmartList<PsiExtensionMethod>();
        PsiAugmentProvider.forEach(aClass.getProject(), provider -> {
            List<PsiExtensionMethod> methods = provider.getExtensionMethods(aClass, nameHint, context);
            for (PsiExtensionMethod method : methods) {
                try {
                    PsiUtilCore.ensureValid(method);
                    extensionMethods.add(method);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(PluginException.createByClass(e, provider.getClass()));
                }
            }
            return true;
        });
        SmartList<PsiExtensionMethod> smartList = extensionMethods;
        if (smartList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(21);
        }
        Ref result2 = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider -> {
            PsiType type = provider.inferType(typeElement);
            if (type != null) {
                try {
                    PsiUtil.ensureValidType(type);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass(e, provider.getClass());
                }
                result2.set(type);
                return false;
            }
            return true;
        });
        return (PsiType)result2.get();
    }

    public static boolean isInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(22);
        }
        AtomicBoolean result2 = new AtomicBoolean();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider -> {
            boolean canInfer = provider.canInferType(typeElement);
            if (canInfer) {
                result2.set(true);
            }
            return !canInfer;
        });
        return result2.get();
    }

    public static boolean canTrustFieldInitializer(@NotNull PsiField field) {
        if (field == null) {
            PsiAugmentProvider.$$$reportNull$$$0(23);
        }
        AtomicBoolean result2 = new AtomicBoolean(true);
        PsiAugmentProvider.forEach(field.getProject(), provider -> {
            boolean mightBeReplaced = provider.fieldInitializerMightBeChanged(field);
            if (mightBeReplaced) {
                result2.set(false);
            }
            return !mightBeReplaced;
        });
        return result2.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList, @NotNull Project project, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(24);
        }
        if (project == null) {
            PsiAugmentProvider.$$$reportNull$$$0(25);
        }
        if (modifiers == null) {
            PsiAugmentProvider.$$$reportNull$$$0(26);
        }
        Ref<Set<String>> result2 = Ref.create(modifiers);
        PsiAugmentProvider.forEach(project, provider -> {
            result2.set(provider.transformModifiers(modifierList, Collections.unmodifiableSet((Set)result2.get())));
            return true;
        });
        Set<String> set = result2.get();
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(27);
        }
        return set;
    }

    private static void forEach(Project project, Processor<? super PsiAugmentProvider> processor) {
        for (PsiAugmentProvider provider : EP.getValue().getExtensionList()) {
            if (!DumbService.getInstance(project).isUsableInCurrentContext(provider)) continue;
            try {
                boolean goOn = processor.process(provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAugments";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionMethods";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifierProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 27: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fieldInitializerMightBeChanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectAugments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInferredType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canTrustFieldInitializer";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "transformModifierProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 15: 
            case 18: 
            case 20: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

