/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Interner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConstantExpressionVisitor
extends JavaElementVisitor
implements PsiConstantEvaluationHelper.AuxEvaluator {
    private final Interner<String> myInterner = Interner.createStringInterner();
    private Set<PsiVariable> myVisitedVars;
    private final Map<PsiElement, Object> myCachedValues = new HashMap<PsiElement, Object>();
    private final boolean myThrowExceptionOnOverflow;
    private Object myResult;
    private final PsiConstantEvaluationHelper.AuxEvaluator myAuxEvaluator;

    ConstantExpressionVisitor(Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myVisitedVars = visitedVars;
        this.myThrowExceptionOnOverflow = throwExceptionOnOverflow;
        this.myAuxEvaluator = auxEvaluator;
    }

    Object handle(PsiElement element) {
        this.myResult = null;
        element.accept(this);
        this.store(element, this.myResult);
        return this.myResult;
    }

    private Object getStoredValue(PsiElement element) {
        return this.myCachedValues.remove(element);
    }

    void store(PsiElement element, Object value) {
        this.myCachedValues.put(element, value);
    }

    @Override
    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
        Object value;
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.myResult = (value = expression.getValue()) instanceof String ? this.myInterner.intern((String)value) : value;
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(1);
        }
        PsiTypeElement castTypeElement = expression.getCastType();
        PsiExpression operand = expression.getOperand();
        Object opValue = this.getStoredValue(operand);
        if (castTypeElement == null || opValue == null) {
            this.myResult = null;
            return;
        }
        PsiType castType = castTypeElement.getType();
        if (!(castType instanceof PsiPrimitiveType) && !castType.equalsToText("java.lang.String")) {
            this.myResult = null;
            return;
        }
        this.myResult = ConstantExpressionUtil.computeCastTo(opValue, castType);
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(2);
        }
        Object then2 = this.getStoredValue(expression.getThenExpression());
        Object els = this.getStoredValue(expression.getElseExpression());
        Object condition = this.getStoredValue(expression.getCondition());
        if (then2 == null || els == null) {
            this.myResult = null;
            return;
        }
        Object value = null;
        if (condition instanceof Boolean) {
            value = (Boolean)condition != false ? then2 : els;
        }
        this.myResult = value;
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(3);
        }
        if (PsiUtilCore.hasErrorElementChild(expression)) {
            this.myResult = null;
            return;
        }
        PsiExpression[] operands = expression.getOperands();
        Object lValue = this.getStoredValue(operands[0]);
        if (lValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            Object rValue = this.getStoredValue(operand);
            if (rValue == null) {
                this.myResult = null;
                break;
            }
            this.myResult = this.compute(lValue, rValue, tokenType, expression);
            if (this.myResult == null) break;
            lValue = this.myResult;
        }
        if (this.myResult instanceof String) {
            this.myResult = this.myInterner.intern((String)this.myResult);
        }
    }

    private Object compute(Object lOperandValue, Object rOperandValue, IElementType tokenType, PsiPolyadicExpression expression) {
        Object value = null;
        if (tokenType == JavaTokenType.PLUS) {
            if (lOperandValue instanceof String || rOperandValue instanceof String) {
                String l = ConstantExpressionVisitor.computeValueToString(lOperandValue);
                String r = ConstantExpressionVisitor.computeValueToString(rOperandValue);
                value = l + r;
            } else {
                if (lOperandValue instanceof Character) {
                    lOperandValue = (int)((Character)lOperandValue).charValue();
                }
                if (rOperandValue instanceof Character) {
                    rOperandValue = (int)((Character)rOperandValue).charValue();
                }
                if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                    if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                        value = ((Number)lOperandValue).doubleValue() + ((Number)rOperandValue).doubleValue();
                        this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                    } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                        value = Float.valueOf(((Number)lOperandValue).floatValue() + ((Number)rOperandValue).floatValue());
                        this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                    } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                        long r;
                        long l = ((Number)lOperandValue).longValue();
                        value = l + (r = ((Number)rOperandValue).longValue());
                        this.checkAdditionOverflow((Long)value >= 0L, l >= 0L, r >= 0L, expression);
                    } else {
                        int r;
                        int l = ((Number)lOperandValue).intValue();
                        value = l + (r = ((Number)rOperandValue).intValue());
                        this.checkAdditionOverflow((Integer)value >= 0, l >= 0, r >= 0, expression);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.MINUS) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = ((Number)lOperandValue).doubleValue() - ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = Float.valueOf(((Number)lOperandValue).floatValue() - ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r;
                    long l = ((Number)lOperandValue).longValue();
                    value = l - (r = ((Number)rOperandValue).longValue());
                    this.checkAdditionOverflow((Long)value >= 0L, l >= 0L, r < 0L, expression);
                } else {
                    int r;
                    int l = ((Number)lOperandValue).intValue();
                    value = l - (r = ((Number)rOperandValue).intValue());
                    this.checkAdditionOverflow((Integer)value >= 0, l >= 0, r < 0, expression);
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND) {
            if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            } else if (lOperandValue instanceof Boolean && !((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && !((Boolean)rOperandValue).booleanValue()) {
                value = Boolean.FALSE;
            }
        } else if (tokenType == JavaTokenType.OROR) {
            if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            } else if (lOperandValue instanceof Boolean && ((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && ((Boolean)rOperandValue).booleanValue()) {
                value = Boolean.TRUE;
            }
        } else if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            value = ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            value = ConstantExpressionVisitor.handleEqualityComparison(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.ASTERISK) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = ((Number)lOperandValue).doubleValue() * ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = Float.valueOf(((Number)lOperandValue).floatValue() * ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value = l * r;
                    this.checkMultiplicationOverflow((Long)value, l, r, expression);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value = l * r;
                    this.checkMultiplicationOverflow(((Integer)value).intValue(), l, r, expression);
                }
            }
        } else if (tokenType == JavaTokenType.DIV) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = ((Number)lOperandValue).doubleValue() / ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = Float.valueOf(((Number)lOperandValue).floatValue() / ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r = ((Number)rOperandValue).longValue();
                    long l = ((Number)lOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression);
                    value = r == 0L ? null : Long.valueOf(l / r);
                } else {
                    int r = ((Number)rOperandValue).intValue();
                    int l = ((Number)lOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression);
                    value = r == 0 ? null : Integer.valueOf(l / r);
                }
            }
        } else if (tokenType == JavaTokenType.PERC) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                double rVal = ((Number)rOperandValue).doubleValue();
                if (this.myThrowExceptionOnOverflow && rVal == 0.0) {
                    throw new ConstantEvaluationOverflowException(expression);
                }
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = ((Number)lOperandValue).doubleValue() % ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = Float.valueOf(((Number)lOperandValue).floatValue() % ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression);
                    value = r == 0L ? null : Long.valueOf(l % r);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression);
                    value = r == 0 ? null : Integer.valueOf(l % r);
                }
            }
        } else if (tokenType == JavaTokenType.LTLT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                if (lOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value = l << (int)r;
                    this.checkMultiplicationOverflow((Long)value, l, (long)Math.pow(2.0, r & 0x3FL), expression);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value = l << r;
                    this.checkMultiplicationOverflow(((Integer)value).intValue(), l, (long)Math.pow(2.0, r & 0x1F), expression);
                }
            }
        } else if (tokenType == JavaTokenType.GTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >>> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >>> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.AND) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() & ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() & ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() | ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() | ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.XOR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() ^ ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() ^ ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue ^ (Boolean)rOperandValue;
            }
        }
        return value;
    }

    private static String computeValueToString(Object value) {
        if (value instanceof PsiType) {
            if (value instanceof PsiArrayType) {
                return "class " + ClassUtil.getClassObjectPresentation((PsiType)value);
            }
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)value);
            String prefix = psiClass == null ? "" : (psiClass.isInterface() ? "interface " : "class ");
            return prefix + ((PsiType)value).getCanonicalText();
        }
        return value.toString();
    }

    @Nullable
    private static Boolean handleEqualityComparison(Object lOperandValue, Object rOperandValue, IElementType tokenType) {
        if (lOperandValue instanceof String && rOperandValue instanceof String || lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
            return lOperandValue.equals(rOperandValue) == (tokenType == JavaTokenType.EQEQ);
        }
        return ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
    }

    private static Boolean compareNumbers(Object o1, Object o2, IElementType op) {
        int result2;
        if (o1 instanceof Character) {
            o1 = (int)((Character)o1).charValue();
        }
        if (o2 instanceof Character) {
            o2 = (int)((Character)o2).charValue();
        }
        if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Double || n2 instanceof Double) {
            double v1 = n1.doubleValue();
            double v2 = n2.doubleValue();
            if (Double.isNaN(v1) || Double.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result2 = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else if (n1 instanceof Float || n2 instanceof Float) {
            float v1 = n1.floatValue();
            float v2 = n2.floatValue();
            if (Float.isNaN(v1) || Float.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result2 = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else {
            result2 = n1 instanceof Long || n2 instanceof Long ? Long.compare(n1.longValue(), n2.longValue()) : Integer.compare(n1.intValue(), n2.intValue());
        }
        if (op == JavaTokenType.EQEQ) {
            return result2 == 0;
        }
        if (op == JavaTokenType.LT) {
            return result2 < 0;
        }
        if (op == JavaTokenType.LE) {
            return result2 <= 0;
        }
        if (op == JavaTokenType.GT) {
            return result2 > 0;
        }
        if (op == JavaTokenType.GE) {
            return result2 >= 0;
        }
        if (op == JavaTokenType.NE) {
            return result2 != 0;
        }
        throw new IllegalArgumentException("Unexpected operator: " + op);
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        PsiExpression operand;
        Object operandValue;
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(4);
        }
        if ((operandValue = this.getStoredValue(operand = expression.getOperand())) == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression.getOperationTokenType();
        Object value = null;
        if (tokenType == JavaTokenType.MINUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                if (operandValue instanceof Double) {
                    value = -((Number)operandValue).doubleValue();
                } else if (operandValue instanceof Float) {
                    value = Float.valueOf(-((Number)operandValue).floatValue());
                } else if (operandValue instanceof Long) {
                    value = -((Number)operandValue).longValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).longValue() == Long.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression);
                    }
                } else {
                    value = -((Number)operandValue).intValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).intValue() == Integer.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                value = operandValue;
            }
        } else if (tokenType == JavaTokenType.TILDE) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(operandValue)) {
                value = operandValue instanceof Long ? (Number)(((Number)operandValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (Number)(~((Number)operandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.EXCL && operandValue instanceof Boolean) {
            value = (Boolean)operandValue == false;
        }
        this.myResult = value;
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(5);
        }
        this.myResult = this.getStoredValue(expression.getExpression());
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(6);
        }
        this.myResult = this.myAuxEvaluator != null ? this.myAuxEvaluator.computeExpression(expression, this) : null;
    }

    @Override
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        PsiClass aClass;
        PsiType type;
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(7);
        }
        if ((type = expression.getOperand().getType()) instanceof PsiClassReferenceType && (aClass = ((PsiClassReferenceType)type).resolve()) != null) {
            type = JavaPsiFacade.getElementFactory(expression.getProject()).createType(aClass, ((PsiClassReferenceType)type).getParameters());
        }
        this.myResult = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        PsiElement resolvedExpression;
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(8);
        }
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        while (qualifierExpression != null) {
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                this.myResult = null;
                return;
            }
            PsiReferenceExpression qualifier = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiPackage) break;
            if (!(resolved instanceof PsiClass)) {
                this.myResult = null;
                return;
            }
            qualifierExpression = qualifier.getQualifierExpression();
        }
        if ((resolvedExpression = expression.resolve()) instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolvedExpression;
            if (this.myVisitedVars != null && this.myVisitedVars.contains(variable)) {
                this.myResult = null;
                return;
            }
            Set<PsiVariable> oldVisitedVars = this.myVisitedVars;
            if (this.myVisitedVars == null) {
                this.myVisitedVars = new HashSet<PsiVariable>();
            }
            this.myVisitedVars.add(variable);
            try {
                Object object = this.myResult = variable instanceof PsiVariableEx && !(variable instanceof PsiEnumConstant) ? ((PsiVariableEx)variable).computeConstantValue(this.myVisitedVars) : null;
                if (this.myResult == null && this.myAuxEvaluator != null) {
                    this.myResult = this.myAuxEvaluator.computeExpression(expression, this);
                }
                return;
            }
            finally {
                this.myVisitedVars.remove(variable);
                this.myVisitedVars = oldVisitedVars;
            }
        }
        this.myResult = null;
    }

    private static boolean isIntegral(Object o) {
        return o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof Character;
    }

    private void checkDivisionOverflow(long l, long r, long minValue, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L) {
            throw new ConstantEvaluationOverflowException(expression);
        }
        if (r == -1L && l == minValue) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkMultiplicationOverflow(long result2, long l, long r, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L || l == 0L) {
            return;
        }
        if (result2 / r != l || l < 0L ^ r < 0L != result2 < 0L) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkAdditionOverflow(boolean resultPositive, boolean lPositive, boolean rPositive, PsiElement expression) {
        boolean overflow;
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        boolean bl = overflow = lPositive == rPositive && lPositive != resultPositive;
        if (overflow) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkRealNumberOverflow(Object result2, Object lOperandValue, Object rOperandValue, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (lOperandValue instanceof Float && ((Float)lOperandValue).isInfinite()) {
            return;
        }
        if (lOperandValue instanceof Double && ((Double)lOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Float && ((Float)rOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Double && ((Double)rOperandValue).isInfinite()) {
            return;
        }
        if (result2 instanceof Float && ((Float)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression);
        }
        if (result2 instanceof Double && ((Double)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    @Override
    public Object computeExpression(@NotNull PsiExpression expression, @NotNull PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(9);
        }
        if (auxEvaluator == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(10);
        }
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, this.myVisitedVars, this.myThrowExceptionOnOverflow, auxEvaluator);
    }

    @Override
    @NotNull
    public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
        throw new AssertionError((Object)"should not be called");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxEvaluator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/ConstantExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "computeExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

