/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.util.PsiUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    private PsiType myT;

    protected InputOutputConstraintFormula(PsiType t) {
        this.myT = t;
    }

    public abstract PsiExpression getExpression();

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiType var3, Set<? super InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session) {
        PsiExpression psiExpression = this.getExpression();
        PsiType type = this.myT;
        if (psiExpression instanceof PsiFunctionalExpression) {
            PsiType functionType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            InferenceVariable inferenceVariable = session.getInferenceVariable(type);
            if (inferenceVariable != null) {
                HashSet<InferenceVariable> result2 = new HashSet<InferenceVariable>();
                result2.add(inferenceVariable);
                return result2;
            }
            if (LambdaUtil.isFunctionalType(type) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(type, (PsiLambdaExpression)psiExpression, false) : type))) != null) {
                PsiType returnType;
                HashSet<InferenceVariable> result3 = new HashSet<InferenceVariable>();
                PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                if (psiExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)psiExpression).hasFormalParameterTypes() || psiExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)psiExpression).isExact()) {
                    for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                        session.collectDependencies(substitutor.substitute(parameter.getType()), result3);
                    }
                }
                if ((returnType = interfaceMethod.getReturnType()) != null) {
                    this.collectReturnTypeVariables(session, psiExpression, substitutor.substitute(returnType), result3);
                }
                return result3;
            }
        }
        if (psiExpression instanceof PsiParenthesizedExpression) {
            PsiExpression expression2 = ((PsiParenthesizedExpression)psiExpression).getExpression();
            return expression2 != null ? this.createSelfConstraint(type, expression2).getInputVariables(session) : null;
        }
        if (psiExpression instanceof PsiConditionalExpression) {
            Set<InferenceVariable> elseResult;
            PsiExpression thenExpression = ((PsiConditionalExpression)psiExpression).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)psiExpression).getElseExpression();
            Set<InferenceVariable> thenResult = thenExpression != null ? this.createSelfConstraint(type, thenExpression).getInputVariables(session) : null;
            Set<InferenceVariable> set = elseResult = elseExpression != null ? this.createSelfConstraint(type, elseExpression).getInputVariables(session) : null;
            if (thenResult == null) {
                return elseResult;
            }
            if (elseResult == null) {
                return thenResult;
            }
            thenResult.addAll(elseResult);
            return thenResult;
        }
        if (psiExpression instanceof PsiSwitchExpression) {
            Set<InferenceVariable> variables = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)psiExpression).stream().flatMap(expression -> {
                Set<InferenceVariable> inputVariables = this.createSelfConstraint(type, (PsiExpression)expression).getInputVariables(session);
                return inputVariables != null ? inputVariables.stream() : Stream.empty();
            }).collect(Collectors.toSet());
            return variables.isEmpty() ? null : variables;
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session) {
        HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
        session.collectDependencies(this.myT, mentionedVariables);
        if (inputVariables != null) {
            mentionedVariables.removeAll(inputVariables);
        }
        return mentionedVariables.isEmpty() ? null : mentionedVariables;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache2) {
        this.myT = substitutor.substitute(this.myT);
    }

    public PsiType getCurrentType() {
        return this.myT;
    }

    public String toString() {
        return this.getExpression().getText() + " -> " + this.myT.getPresentableText();
    }
}

