/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.IntelliJContextElement;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.util.concurrency.Propagation;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelicateCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0016\u001a\u00020\u00062\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J'\u0010\u0016\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u001cH\u0007J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J5\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/util/concurrency/ChildContext;", "", "context", "Lkotlin/coroutines/CoroutineContext;", "continuation", "Lkotlin/coroutines/Continuation;", "", "ijElements", "", "Lcom/intellij/concurrency/IntelliJContextElement;", "<init>", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;Ljava/util/List;)V", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getContinuation", "()Lkotlin/coroutines/Continuation;", "getIjElements", "()Ljava/util/List;", "job", "Lkotlinx/coroutines/Job;", "getJob", "()Lkotlinx/coroutines/Job;", "runInChildContext", "action", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "T", "completeOnFinish", "", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "applyContextActions", "Lcom/intellij/openapi/application/AccessToken;", "installThreadContext", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\npropagation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 propagation.kt\ncom/intellij/util/concurrency/ChildContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,446:1\n1#2:447\n*E\n"})
public final class ChildContext {
    @NotNull
    private final CoroutineContext context;
    @Nullable
    private final Continuation<Unit> continuation;
    @NotNull
    private final List<IntelliJContextElement> ijElements;

    public ChildContext(@NotNull CoroutineContext context, @Nullable Continuation<? super Unit> continuation, @NotNull List<? extends IntelliJContextElement> ijElements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(ijElements, (String)"ijElements");
        this.context = context;
        this.continuation = continuation;
        this.ijElements = ijElements;
    }

    @NotNull
    public final CoroutineContext getContext() {
        return this.context;
    }

    @Nullable
    public final Continuation<Unit> getContinuation() {
        return this.continuation;
    }

    @NotNull
    public final List<IntelliJContextElement> getIjElements() {
        return this.ijElements;
    }

    @Nullable
    public final Job getJob() {
        CoroutineContext coroutineContext = this.continuation;
        return coroutineContext != null && (coroutineContext = coroutineContext.getContext()) != null ? JobKt.getJob(coroutineContext) : null;
    }

    public final void runInChildContext(@NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.runInChildContext(true, (Function0)new Function0<Unit>((Object)action2){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T runInChildContext(boolean completeOnFinish, @NotNull Function0<? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (this.continuation == null) {
            AutoCloseable autoCloseable = ChildContext.applyContextActions$default(this, false, 1, null);
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                Object object2 = action2.invoke();
                object = object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        } else {
            object = Propagation.runAsCoroutine(this.continuation, completeOnFinish, () -> ChildContext.runInChildContext$lambda$2(this, action2));
        }
        return object;
    }

    @DelicateCoroutinesApi
    @NotNull
    public final AccessToken applyContextActions(boolean installThreadContext) {
        AccessToken accessToken;
        if (installThreadContext) {
            accessToken = ThreadContext.installThreadContext(this.context, false);
        } else {
            AccessToken accessToken2 = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNull((Object)accessToken2);
            accessToken = accessToken2;
        }
        AccessToken installToken = accessToken;
        for (IntelliJContextElement elem : this.ijElements) {
            elem.beforeChildStarted(this.context);
        }
        return new AccessToken(installToken, this){
            final /* synthetic */ AccessToken $installToken;
            final /* synthetic */ ChildContext this$0;
            {
                this.$installToken = $installToken;
                this.this$0 = $receiver;
            }

            public void finish() {
                this.$installToken.finish();
                for (IntelliJContextElement elem : CollectionsKt.reversed((Iterable)this.this$0.getIjElements())) {
                    elem.afterChildCompleted(this.this$0.getContext());
                }
            }
        };
    }

    public static /* synthetic */ AccessToken applyContextActions$default(ChildContext childContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return childContext.applyContextActions(bl);
    }

    @NotNull
    public final CoroutineContext component1() {
        return this.context;
    }

    @Nullable
    public final Continuation<Unit> component2() {
        return this.continuation;
    }

    @NotNull
    public final List<IntelliJContextElement> component3() {
        return this.ijElements;
    }

    @NotNull
    public final ChildContext copy(@NotNull CoroutineContext context, @Nullable Continuation<? super Unit> continuation, @NotNull List<? extends IntelliJContextElement> ijElements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(ijElements, (String)"ijElements");
        return new ChildContext(context, continuation, ijElements);
    }

    public static /* synthetic */ ChildContext copy$default(ChildContext childContext, CoroutineContext coroutineContext, Continuation continuation, List list, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineContext = childContext.context;
        }
        if ((n & 2) != 0) {
            continuation = childContext.continuation;
        }
        if ((n & 4) != 0) {
            list = childContext.ijElements;
        }
        return childContext.copy(coroutineContext, continuation, list);
    }

    @NotNull
    public String toString() {
        return "ChildContext(context=" + this.context + ", continuation=" + this.continuation + ", ijElements=" + this.ijElements + ')';
    }

    public int hashCode() {
        int result2 = this.context.hashCode();
        result2 = result2 * 31 + (this.continuation == null ? 0 : this.continuation.hashCode());
        result2 = result2 * 31 + ((Object)this.ijElements).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChildContext)) {
            return false;
        }
        ChildContext childContext = (ChildContext)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)childContext.context)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.continuation, childContext.continuation)) {
            return false;
        }
        return Intrinsics.areEqual(this.ijElements, childContext.ijElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object runInChildContext$lambda$2(ChildContext this$0, Function0 $action) {
        Object object;
        AutoCloseable autoCloseable = ChildContext.applyContextActions$default(this$0, false, 1, null);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            object = $action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }
}

