/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.hash.EqualityPolicy;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class LinkedCustomHashMap<K, V> {
    private Entry<K, V>[] entries;
    private Entry<K, V> top;
    private Entry<K, V> back;
    private transient int mask;
    private transient int n;
    private final RemoveCallback<K, V> removeEldestEntry;
    private transient int maxFill;
    private int size;
    private static final float LOAD_FACTOR = 0.6f;
    private final EqualityPolicy<? super K> hashingStrategy;

    @TestOnly
    LinkedCustomHashMap() {
        this(EqualityPolicy.CANONICAL, (map2, eldest, key, value) -> false);
    }

    @TestOnly
    LinkedCustomHashMap(@NotNull RemoveCallback<K, V> removeEldestEntry) {
        if (removeEldestEntry == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(0);
        }
        this(EqualityPolicy.CANONICAL, removeEldestEntry);
    }

    LinkedCustomHashMap(@NotNull EqualityPolicy<? super K> hashingStrategy2, @NotNull RemoveCallback<K, V> removeEldestEntry) {
        if (hashingStrategy2 == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(1);
        }
        if (removeEldestEntry == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(2);
        }
        this.hashingStrategy = hashingStrategy2;
        this.removeEldestEntry = removeEldestEntry;
        this.init();
    }

    private void init() {
        this.n = HashCommon.arraySize(16, 0.6f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, 0.6f);
        this.entries = new Entry[this.n + 1];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.back = null;
        this.top = null;
        this.init();
    }

    public V get(K key) {
        Entry<K, V>[] entries2 = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry e = entries2[index];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e);
                return (V)e.value;
            }
            e = e.hashNext;
        }
        return null;
    }

    private int hashKey(K key) {
        return key == null ? 0 : HashCommon.mix(this.hashingStrategy.getHashCode(key));
    }

    public V put(K key, @NotNull V value) {
        if (value == null) {
            LinkedCustomHashMap.$$$reportNull$$$0(3);
        }
        Entry<K, V>[] table = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry<K, V> e = table[index];
        while (e != null) {
            Object entryKey;
            if (((Entry)e).keyHash == hash && ((entryKey = ((Entry)e).key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = ((Entry)e).hashNext;
        }
        e = new Entry<K, V>(key, value, hash);
        ((Entry)e).hashNext = (Entry)table[index];
        table[index] = e;
        Entry<K, V> top = this.top;
        ((Entry)e).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.removeEldestEntry.check(this.size, this.back, ((Entry)this.back).key, ((Entry)this.back).value)) {
            V value1 = this.remove(((Entry)this.back).key);
            assert (value1 != null) : "LinkedHashMap.Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
        } else if (this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, 0.6f));
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V remove(K key) {
        Object entryKey;
        Entry<K, V>[] entries2 = this.entries;
        int hash = this.hashKey(key);
        int index = hash & this.mask;
        Entry e = entries2[index];
        if (e == null) {
            return null;
        }
        if (e.keyHash == hash && ((entryKey = e.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
            entries2[index] = e.hashNext;
        } else {
            Entry last2;
            do {
                last2 = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.keyHash != hash || (entryKey = e.key) != key && !this.hashingStrategy.isEqual(entryKey, key));
            last2.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return (V)e.value;
    }

    @NotNull
    public Set<K> keySet() {
        return new KeySet();
    }

    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private void moveToTop(Entry<K, V> e) {
        Entry<K, V> top = this.top;
        if (top == e) {
            return;
        }
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        prev.next = next;
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)top).previous = (Entry)e;
        ((Entry)e).next = (Entry)top;
        ((Entry)e).previous = null;
        this.top = e;
    }

    private void unlink(Entry<K, V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e).previous = null;
        ((Entry)e).next = null;
    }

    private void rehash(int newN) {
        this.mask = newN - 1;
        this.n = newN;
        this.maxFill = HashCommon.maxFill(this.n, 0.6f);
        Entry[] entries2 = new Entry[newN];
        Entry e = this.back;
        while (e != null) {
            int hash = e.keyHash & this.mask;
            e.hashNext = entries2[hash];
            entries2[hash] = e;
            e = e.previous;
        }
        this.entries = entries2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeEldestEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/LinkedCustomHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int keyHash;
        private V value;
        private Entry<K, V> next;
        private Entry<K, V> previous;
        private Entry<K, V> hashNext;

        Entry(K key, V value, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result2 = this.value;
            this.value = value;
            return result2;
        }
    }

    @FunctionalInterface
    static interface RemoveCallback<K, V> {
        public boolean check(int var1, Map.Entry<K, V> var2, K var3, V var4);
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new LinkedHashIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().key;
                }
            };
        }

        @Override
        public int size() {
            return LinkedCustomHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LinkedCustomHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return LinkedCustomHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            LinkedCustomHashMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return LinkedCustomHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            for (Entry entry : LinkedCustomHashMap.this.entries) {
                if (entry == null || !entry.value.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            LinkedCustomHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedHashIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = LinkedCustomHashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return LinkedCustomHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return LinkedCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            LinkedCustomHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<K, V> e;
        private Entry<K, V> last;

        private LinkedHashIterator() {
            this.e = LinkedCustomHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedCustomHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.e = result2.previous;
            return result2;
        }
    }
}

