/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.prefix.map;

import com.intellij.util.containers.OptionalKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001%B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0014\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J1\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0014\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J\u0014\u0010\u0019\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012J$\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J>\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0018\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00020\"0!H\u0002J\"\u0010#\u001a\u00020\"2\u0018\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00020$0!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/util/containers/prefix/map/PrefixTreeNode;", "Key", "Value", "", "<init>", "()V", "size", "", "state", "Lcom/intellij/util/containers/OptionalKt;", "children", "Ljava/util/LinkedHashMap;", "isLeaf", "", "isEmpty", "getSize", "getValue", "key", "", "setValue", "value", "(Ljava/util/List;Ljava/lang/Object;)Lcom/intellij/util/containers/OptionalKt;", "removeValue", "index", "(ILjava/util/List;Ljava/lang/Object;)Lcom/intellij/util/containers/OptionalKt;", "containsKey", "getValues", "getAncestorValues", "getDescendantValues", "getRootValues", "findNode", "traverseNode", "process", "Lkotlin/Function1;", "", "traverseTree", "Lcom/intellij/util/containers/prefix/map/PrefixTreeNode$TraverseDecision;", "TraverseDecision", "intellij.platform.util.base"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPrefixTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefixTreeNode.kt\ncom/intellij/util/containers/prefix/map/PrefixTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,161:1\n1#2:162\n381#3,7:163\n*S KotlinDebug\n*F\n+ 1 PrefixTreeNode.kt\ncom/intellij/util/containers/prefix/map/PrefixTreeNode\n*L\n51#1:163,7\n*E\n"})
public final class PrefixTreeNode<Key, Value> {
    private int size;
    @NotNull
    private OptionalKt<? extends Value> state = OptionalKt.Companion.getEMPTY();
    @NotNull
    private final LinkedHashMap<Key, PrefixTreeNode<Key, Value>> children = new LinkedHashMap();

    public final boolean isLeaf() {
        return this.children.isEmpty();
    }

    public final boolean isEmpty() {
        return this.isLeaf() && this.state.isNotPresent();
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final OptionalKt<Value> getValue(@NotNull List<? extends Key> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        PrefixTreeNode<? extends Key, Value> prefixTreeNode = this.findNode(key);
        if (prefixTreeNode == null || (prefixTreeNode = prefixTreeNode.state) == null) {
            prefixTreeNode = OptionalKt.Companion.getEMPTY();
        }
        return prefixTreeNode;
    }

    @NotNull
    public final OptionalKt<Value> setValue(@NotNull List<? extends Key> key, Value value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.setValue(0, key, value);
    }

    @NotNull
    public final OptionalKt<Value> removeValue(@NotNull List<? extends Key> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.removeValue(0, key);
    }

    /*
     * WARNING - void declaration
     */
    private final OptionalKt<Value> setValue(int index, List<? extends Key> key, Value value) {
        PrefixTreeNode childNode;
        OptionalKt<Value> previousState;
        Object object;
        void $this$getOrPut$iv;
        if (!(index >= 0 && index <= key.size())) {
            boolean $i$a$-require-PrefixTreeNode$setValue$22 = false;
            String $i$a$-require-PrefixTreeNode$setValue$22 = "Index " + index + " out of bound [0, " + key.size() + ']';
            throw new IllegalArgumentException($i$a$-require-PrefixTreeNode$setValue$22.toString());
        }
        if (index == key.size()) {
            OptionalKt<Value> previousState2 = this.state;
            this.state = OptionalKt.Companion.of(value);
            if (!previousState2.isPresent()) {
                ++this.size;
            }
            return previousState2;
        }
        Map $i$a$-require-PrefixTreeNode$setValue$22 = this.children;
        Key key$iv = key.get(index);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PrefixTreeNode<Key, Value> answer$iv = new PrefixTreeNode<Key, Value>();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (!(previousState = (childNode = (PrefixTreeNode)object).setValue(index + 1, key, value)).isPresent()) {
            ++this.size;
        }
        return previousState;
    }

    private final OptionalKt<Value> removeValue(int index, List<? extends Key> key) {
        if (!(index >= 0 && index <= key.size())) {
            boolean $i$a$-require-PrefixTreeNode$removeValue$22 = false;
            String $i$a$-require-PrefixTreeNode$removeValue$22 = "Index " + index + " out of bound [0, " + key.size() + ']';
            throw new IllegalArgumentException($i$a$-require-PrefixTreeNode$removeValue$22.toString());
        }
        if (index == key.size()) {
            OptionalKt<Value> previousState = this.state;
            this.state = OptionalKt.Companion.getEMPTY();
            if (previousState.isPresent()) {
                --this.size;
            }
            return previousState;
        }
        PrefixTreeNode<Key, Value> prefixTreeNode = this.children.get(key.get(index));
        if (prefixTreeNode == null) {
            return OptionalKt.Companion.getEMPTY();
        }
        PrefixTreeNode<Key, Value> childNode = prefixTreeNode;
        OptionalKt<Value> previousState = super.removeValue(index + 1, key);
        if (childNode.isEmpty()) {
            this.children.remove(key.get(index));
        }
        if (previousState.isPresent()) {
            --this.size;
        }
        return previousState;
    }

    public final boolean containsKey(@NotNull List<? extends Key> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        PrefixTreeNode<? extends Key, Value> prefixTreeNode = this.findNode(key);
        if (prefixTreeNode == null) {
            return false;
        }
        PrefixTreeNode<? extends Key, Value> node = prefixTreeNode;
        return node.state.isPresent();
    }

    @NotNull
    public final List<Value> getValues() {
        ArrayList result2 = new ArrayList();
        this.traverseTree(arg_0 -> PrefixTreeNode.getValues$lambda$3(result2, arg_0));
        return result2;
    }

    @NotNull
    public final List<Value> getAncestorValues(@NotNull List<? extends Key> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ArrayList result2 = new ArrayList();
        this.traverseNode(key, arg_0 -> PrefixTreeNode.getAncestorValues$lambda$4(result2, arg_0));
        return result2;
    }

    @NotNull
    public final List<Value> getDescendantValues(@NotNull List<? extends Key> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        PrefixTreeNode<Key, Value> prefixTreeNode = this.findNode(key);
        if (prefixTreeNode == null) {
            return CollectionsKt.emptyList();
        }
        PrefixTreeNode<Key, Value> node = prefixTreeNode;
        ArrayList<Value> result2 = new ArrayList<Value>();
        for (Value value : node.getValues()) {
            result2.add(value);
        }
        return result2;
    }

    @NotNull
    public final List<Value> getRootValues() {
        ArrayList result2 = new ArrayList();
        this.traverseTree(arg_0 -> PrefixTreeNode.getRootValues$lambda$5(result2, arg_0));
        return result2;
    }

    private final PrefixTreeNode<Key, Value> findNode(List<? extends Key> key) {
        return this.traverseNode(key, PrefixTreeNode::findNode$lambda$6);
    }

    private final PrefixTreeNode<Key, Value> traverseNode(List<? extends Key> key, Function1<? super OptionalKt<? extends Value>, Unit> process) {
        PrefixTreeNode<Key, Value> node = this;
        process.invoke(node.state);
        for (Key keyElement : key) {
            if (node.children.get(keyElement) == null) {
                return null;
            }
            process.invoke(node.state);
        }
        return node;
    }

    private final void traverseTree(Function1<? super OptionalKt<? extends Value>, ? extends TraverseDecision> process) {
        ArrayDeque queue = new ArrayDeque();
        queue.addLast((Object)this);
        block5: while (!((Collection)queue).isEmpty()) {
            PrefixTreeNode node = (PrefixTreeNode)queue.removeFirst();
            switch (WhenMappings.$EnumSwitchMapping$0[((TraverseDecision)((Object)process.invoke(node.state))).ordinal()]) {
                case 1: {
                    break block5;
                }
                case 2: {
                    continue block5;
                }
                case 3: {
                    Iterator<PrefixTreeNode<Key, Value>> iterator2 = node.children.values().iterator();
                    while (iterator2.hasNext()) {
                        PrefixTreeNode<Key, Value> child;
                        Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                        queue.add(child);
                    }
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private static final TraverseDecision getValues$lambda$3(ArrayList $result, OptionalKt state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isPresent()) {
            $result.add(state.get());
        }
        return TraverseDecision.CONTINUE;
    }

    private static final Unit getAncestorValues$lambda$4(ArrayList $result, OptionalKt state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isPresent()) {
            $result.add(state.get());
        }
        return Unit.INSTANCE;
    }

    private static final TraverseDecision getRootValues$lambda$5(ArrayList $result, OptionalKt state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.isPresent()) {
            $result.add(state.get());
        }
        return state.isPresent() ? TraverseDecision.DO_NOT_GO_DEEPER : TraverseDecision.CONTINUE;
    }

    private static final Unit findNode$lambda$6(OptionalKt it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/containers/prefix/map/PrefixTreeNode$TraverseDecision;", "", "<init>", "(Ljava/lang/String;I)V", "CONTINUE", "STOP", "DO_NOT_GO_DEEPER", "intellij.platform.util.base"})
    private static final class TraverseDecision
    extends Enum<TraverseDecision> {
        public static final /* enum */ TraverseDecision CONTINUE = new TraverseDecision();
        public static final /* enum */ TraverseDecision STOP = new TraverseDecision();
        public static final /* enum */ TraverseDecision DO_NOT_GO_DEEPER = new TraverseDecision();
        private static final /* synthetic */ TraverseDecision[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TraverseDecision[] values() {
            return (TraverseDecision[])$VALUES.clone();
        }

        public static TraverseDecision valueOf(String value) {
            return Enum.valueOf(TraverseDecision.class, value);
        }

        @NotNull
        public static EnumEntries<TraverseDecision> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = traverseDecisionArray = new TraverseDecision[]{TraverseDecision.CONTINUE, TraverseDecision.STOP, TraverseDecision.DO_NOT_GO_DEEPER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TraverseDecision.values().length];
            try {
                nArray[TraverseDecision.STOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TraverseDecision.DO_NOT_GO_DEEPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TraverseDecision.CONTINUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

