/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.io.input.CountingInputStream;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 63;
    private static final long[] MASKS = new long[64];
    private final CountingInputStream in;
    private final ByteOrder byteOrder;
    private long bitsCached;
    private int bitsCachedSize;

    public BitInputStream(InputStream in, ByteOrder byteOrder) {
        this.in = new CountingInputStream(in);
        this.byteOrder = byteOrder;
    }

    public void alignWithByteBoundary() {
        int toSkip = this.bitsCachedSize % 8;
        if (toSkip > 0) {
            this.readCachedBits(toSkip);
        }
    }

    public long bitsAvailable() throws IOException {
        return (long)this.bitsCachedSize + 8L * (long)this.in.available();
    }

    public int bitsCached() {
        return this.bitsCachedSize;
    }

    public void clearBitCache() {
        this.bitsCached = 0L;
        this.bitsCachedSize = 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean ensureCache(int count2) throws IOException {
        while (this.bitsCachedSize < count2 && this.bitsCachedSize < 57) {
            long nextByte = this.in.read();
            if (nextByte < 0L) {
                return true;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= nextByte << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= nextByte;
            }
            this.bitsCachedSize += 8;
        }
        return false;
    }

    public long getBytesRead() {
        return this.in.getByteCount();
    }

    private long processBitsGreater57(int count2) throws IOException {
        long overflow = 0L;
        int bitsToAddCount = count2 - this.bitsCachedSize;
        int overflowBits = 8 - bitsToAddCount;
        long nextByte = this.in.read();
        if (nextByte < 0L) {
            return nextByte;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            long bitsToAdd = nextByte & MASKS[bitsToAddCount];
            this.bitsCached |= bitsToAdd << this.bitsCachedSize;
            overflow = nextByte >>> bitsToAddCount & MASKS[overflowBits];
        } else {
            this.bitsCached <<= bitsToAddCount;
            long bitsToAdd = nextByte >>> overflowBits & MASKS[bitsToAddCount];
            this.bitsCached |= bitsToAdd;
            overflow = nextByte & MASKS[overflowBits];
        }
        long bitsOut = this.bitsCached & MASKS[count2];
        this.bitsCached = overflow;
        this.bitsCachedSize = overflowBits;
        return bitsOut;
    }

    public long readBits(int count2) throws IOException {
        if (count2 < 0 || count2 > 63) {
            throw new IOException("count must not be negative or greater than 63");
        }
        if (this.ensureCache(count2)) {
            return -1L;
        }
        if (this.bitsCachedSize < count2) {
            return this.processBitsGreater57(count2);
        }
        return this.readCachedBits(count2);
    }

    private long readCachedBits(int count2) {
        long bitsOut;
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bitsOut = this.bitsCached & MASKS[count2];
            this.bitsCached >>>= count2;
        } else {
            bitsOut = this.bitsCached >> this.bitsCachedSize - count2 & MASKS[count2];
        }
        this.bitsCachedSize -= count2;
        return bitsOut;
    }

    static {
        for (int i = 1; i <= 63; ++i) {
            BitInputStream.MASKS[i] = (MASKS[i - 1] << 1) + 1L;
        }
    }
}

