/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.XmlCharsetDetector;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public final class JpsEncodingProjectConfigurationImpl
extends JpsElementBase<JpsEncodingProjectConfigurationImpl>
implements JpsEncodingProjectConfiguration {
    private static final Logger LOG = Logger.getInstance(JpsEncodingProjectConfigurationImpl.class);
    public static final JpsElementChildRole<JpsEncodingProjectConfiguration> ROLE = JpsElementChildRoleBase.create("encoding configuration");
    private static final String XML_NAME_SUFFIX = ".xml";
    private final Map<String, String> myUrlToEncoding = new HashMap<String, String>();
    private final String myProjectEncoding;

    public JpsEncodingProjectConfigurationImpl(Map<String, String> urlToEncoding, String projectEncoding) {
        this.myUrlToEncoding.putAll(urlToEncoding);
        this.myProjectEncoding = projectEncoding;
    }

    @Override
    @Nullable
    public String getEncoding(@NotNull File file) {
        if (file == null) {
            JpsEncodingProjectConfigurationImpl.$$$reportNull$$$0(0);
        }
        if (JpsEncodingProjectConfigurationImpl.isXmlFile(file)) {
            try {
                String encoding = XmlCharsetDetector.extractXmlEncodingFromProlog(FileUtil.loadFileBytes(file));
                if (encoding != null) {
                    return encoding;
                }
            }
            catch (IOException e) {
                LOG.info("Cannot detect encoding for xml file " + file.getAbsolutePath(), e);
            }
        }
        if (!this.myUrlToEncoding.isEmpty()) {
            File current = file;
            while (current != null) {
                String encoding = this.myUrlToEncoding.get(JpsPathUtil.pathToUrl(FileUtilRt.toSystemIndependentName(current.getPath())));
                if (encoding != null) {
                    return encoding;
                }
                current = FileUtilRt.getParentFile(current);
            }
        }
        if (this.myProjectEncoding != null) {
            return this.myProjectEncoding;
        }
        JpsModel model = this.getModel();
        assert (model != null);
        return JpsEncodingConfigurationService.getInstance().getGlobalEncoding(model.getGlobal());
    }

    private static boolean isXmlFile(File file) {
        String fileName = file.getName();
        return SystemInfo.isFileSystemCaseSensitive ? fileName.endsWith(XML_NAME_SUFFIX) : StringUtil.endsWithIgnoreCase(fileName, XML_NAME_SUFFIX);
    }

    @Override
    @NotNull
    public Map<String, String> getUrlToEncoding() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.myUrlToEncoding);
        if (map2 == null) {
            JpsEncodingProjectConfigurationImpl.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @Override
    @Nullable
    public String getProjectEncoding() {
        return this.myProjectEncoding;
    }

    @Override
    @NotNull
    public JpsEncodingProjectConfigurationImpl createCopy() {
        return new JpsEncodingProjectConfigurationImpl(this.myUrlToEncoding, this.myProjectEncoding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/impl/JpsEncodingProjectConfigurationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/impl/JpsEncodingProjectConfigurationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlToEncoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEncoding";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

