/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"screenShape", "Ljava/awt/Shape;", "Lcom/android/sdklib/devices/Device;", "originX", "", "originY", "size", "Ljava/awt/Dimension;", "sdklib"})
@JvmName(name="DeviceScreenShape")
public final class DeviceScreenShape {
    @Nullable
    public static final Shape screenShape(@NotNull Device $this$screenShape, double originX, double originY, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)$this$screenShape, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Screen screen = $this$screenShape.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        int chin = screen.getChin();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + (double)(2 * (size.height + height)) - (double)height, size.width, height));
        a1.subtract(a2);
        return a1;
    }
}

