/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

public class Atlas {
    public static final int FLAG_ADD_PADDING = 2;
    public static final int FLAG_DEFAULTS = 2;
    private final Policy mPolicy;

    public Atlas(Type type, int width, int height) {
        this(type, width, height, 2);
    }

    public Atlas(Type type, int width, int height, int flags) {
        this.mPolicy = Atlas.findPolicy(type, width, height, flags);
    }

    public Entry pack(int width, int height) {
        return this.pack(width, height, null);
    }

    public Entry pack(int width, int height, Entry entry) {
        if (entry == null) {
            entry = new Entry();
        }
        return this.mPolicy.pack(width, height, entry);
    }

    private static Policy findPolicy(Type type, int width, int height, int flags) {
        switch (type) {
            case SliceMinArea: {
                return new SlicePolicy(width, height, flags, new SlicePolicy.MinAreaSplitDecision());
            }
            case SliceMaxArea: {
                return new SlicePolicy(width, height, flags, new SlicePolicy.MaxAreaSplitDecision());
            }
            case SliceShortAxis: {
                return new SlicePolicy(width, height, flags, new SlicePolicy.ShorterFreeAxisSplitDecision());
            }
            case SliceLongAxis: {
                return new SlicePolicy(width, height, flags, new SlicePolicy.LongerFreeAxisSplitDecision());
            }
        }
        return null;
    }

    private static class SlicePolicy
    extends Policy {
        private final Cell mRoot = new Cell();
        private final SplitDecision mSplitDecision;
        private final int mPadding;

        SlicePolicy(int width, int height, int flags, SplitDecision splitDecision) {
            this.mPadding = (flags & 2) != 0 ? 1 : 0;
            Cell first = new Cell();
            first.x = first.y = this.mPadding;
            first.width = width - 2 * this.mPadding;
            first.height = height - 2 * this.mPadding;
            this.mRoot.next = first;
            this.mSplitDecision = splitDecision;
        }

        @Override
        Entry pack(int width, int height, Entry entry) {
            Cell cell = this.mRoot.next;
            Cell prev = this.mRoot;
            while (cell != null) {
                if (this.insert(cell, prev, width, height, entry)) {
                    return entry;
                }
                prev = cell;
                cell = cell.next;
            }
            return null;
        }

        private boolean insert(Cell cell, Cell prev, int width, int height, Entry entry) {
            if (cell.width < width || cell.height < height) {
                return false;
            }
            int deltaWidth = cell.width - width;
            int deltaHeight = cell.height - height;
            Cell first = new Cell();
            Cell second = new Cell();
            first.x = cell.x + width + this.mPadding;
            first.y = cell.y;
            first.width = deltaWidth - this.mPadding;
            second.x = cell.x;
            second.y = cell.y + height + this.mPadding;
            second.height = deltaHeight - this.mPadding;
            if (this.mSplitDecision.splitHorizontal(deltaWidth, deltaHeight, width, height)) {
                first.height = height;
                second.width = cell.width;
            } else {
                first.height = cell.height;
                second.width = width;
                Cell temp = first;
                first = second;
                second = temp;
            }
            if (first.width > 0 && first.height > 0) {
                prev.next = first;
                prev = first;
            }
            if (second.width > 0 && second.height > 0) {
                prev.next = second;
                second.next = cell.next;
            } else {
                prev.next = cell.next;
            }
            cell.next = null;
            entry.x = cell.x;
            entry.y = cell.y;
            return true;
        }

        private static class LongerFreeAxisSplitDecision
        implements SplitDecision {
            private LongerFreeAxisSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int freeWidth, int freeHeight, int rectWidth, int rectHeight) {
                return freeWidth > freeHeight;
            }
        }

        private static class ShorterFreeAxisSplitDecision
        implements SplitDecision {
            private ShorterFreeAxisSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int freeWidth, int freeHeight, int rectWidth, int rectHeight) {
                return freeWidth <= freeHeight;
            }
        }

        private static class MaxAreaSplitDecision
        implements SplitDecision {
            private MaxAreaSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int freeWidth, int freeHeight, int rectWidth, int rectHeight) {
                return rectWidth * freeHeight <= freeWidth * rectHeight;
            }
        }

        private static class MinAreaSplitDecision
        implements SplitDecision {
            private MinAreaSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int freeWidth, int freeHeight, int rectWidth, int rectHeight) {
                return rectWidth * freeHeight > freeWidth * rectHeight;
            }
        }

        private static interface SplitDecision {
            public boolean splitHorizontal(int var1, int var2, int var3, int var4);
        }

        private static class Cell {
            int x;
            int y;
            int width;
            int height;
            Cell next;

            private Cell() {
            }

            public String toString() {
                return String.format("cell[x=%d y=%d width=%d height=%d", this.x, this.y, this.width, this.height);
            }
        }
    }

    private static abstract class Policy {
        private Policy() {
        }

        abstract Entry pack(int var1, int var2, Entry var3);
    }

    public static class Entry {
        public int x;
        public int y;
    }

    public static enum Type {
        SliceMinArea,
        SliceMaxArea,
        SliceShortAxis,
        SliceLongAxis;

    }
}

