/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.DisplayListCanvas;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowCallbacks;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.android.internal.policy.BackdropFrameRenderer;
import com.android.internal.policy.DecorContext;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.view.FloatingActionMode;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.StandaloneActionMode;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.BackgroundFallback;
import com.android.internal.widget.DecorCaptionView;
import com.android.internal.widget.FloatingToolbar;
import java.util.List;

public class DecorView
extends FrameLayout
implements RootViewSurfaceTaker,
WindowCallbacks {
    private static final String TAG = "DecorView";
    private static final boolean DEBUG_MEASURE = false;
    private static final boolean SWEEP_OPEN_MENU = false;
    private static final int DECOR_SHADOW_FOCUSED_HEIGHT_IN_DIP = 20;
    private static final int DECOR_SHADOW_UNFOCUSED_HEIGHT_IN_DIP = 5;
    private boolean mAllowUpdateElevation = false;
    private boolean mElevationAdjustedForStack = false;
    int mDefaultOpacity = -1;
    private final int mFeatureId;
    private final Rect mDrawingBounds = new Rect();
    private final Rect mBackgroundPadding = new Rect();
    private final Rect mFramePadding = new Rect();
    private final Rect mFrameOffsets = new Rect();
    private boolean mHasCaption = false;
    private boolean mChanging;
    private Drawable mMenuBackground;
    private boolean mWatchingForMenu;
    private int mDownY;
    ActionMode mPrimaryActionMode;
    private ActionMode mFloatingActionMode;
    private ActionBarContextView mPrimaryActionModeView;
    private PopupWindow mPrimaryActionModePopup;
    private Runnable mShowPrimaryActionModePopup;
    private ViewTreeObserver.OnPreDrawListener mFloatingToolbarPreDrawListener;
    private View mFloatingActionModeOriginatingView;
    private FloatingToolbar mFloatingToolbar;
    private ObjectAnimator mFadeAnim;
    private View mStatusGuard;
    private View mNavigationGuard;
    private final ColorViewState mStatusColorViewState = new ColorViewState(4, 0x4000000, 48, 3, "android:status:background", 16908335, 1024);
    private final ColorViewState mNavigationColorViewState = new ColorViewState(2, 0x8000000, 80, 5, "android:navigation:background", 16908336, 0);
    private final Interpolator mShowInterpolator;
    private final Interpolator mHideInterpolator;
    private final int mBarEnterExitDuration;
    final boolean mForceWindowDrawsStatusBarBackground;
    private final int mSemiTransparentStatusBarColor;
    private final BackgroundFallback mBackgroundFallback = new BackgroundFallback();
    private int mLastTopInset = 0;
    private int mLastBottomInset = 0;
    private int mLastRightInset = 0;
    private boolean mLastHasTopStableInset = false;
    private boolean mLastHasBottomStableInset = false;
    private boolean mLastHasRightStableInset = false;
    private int mLastWindowFlags = 0;
    private boolean mLastShouldAlwaysConsumeNavBar = false;
    private int mRootScrollY = 0;
    private PhoneWindow mWindow;
    ViewGroup mContentRoot;
    private Rect mTempRect;
    private Rect mOutsets = new Rect();
    DecorCaptionView mDecorCaptionView;
    int mStackId;
    private boolean mWindowResizeCallbacksAdded = false;
    private Drawable.Callback mLastBackgroundDrawableCb = null;
    private BackdropFrameRenderer mBackdropFrameRenderer = null;
    private Drawable mResizingBackgroundDrawable;
    private Drawable mCaptionBackgroundDrawable;
    private Drawable mUserCaptionBackgroundDrawable;
    private float mAvailableWidth;
    String mLogTag = "DecorView";
    private final Rect mFloatingInsets = new Rect();
    private boolean mApplyFloatingVerticalInsets = false;
    private boolean mApplyFloatingHorizontalInsets = false;
    private int mResizeMode = -1;
    private final int mResizeShadowSize;
    private final Paint mVerticalResizeShadowPaint = new Paint();
    private final Paint mHorizontalResizeShadowPaint = new Paint();

    DecorView(Context context, int featureId, PhoneWindow window, WindowManager.LayoutParams params) {
        super(context);
        this.mFeatureId = featureId;
        this.mShowInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mHideInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mBarEnterExitDuration = context.getResources().getInteger(17694912);
        this.mForceWindowDrawsStatusBarBackground = context.getResources().getBoolean(17957033) && context.getApplicationInfo().targetSdkVersion >= 24;
        this.mSemiTransparentStatusBarColor = context.getResources().getColor(17170546, null);
        this.updateAvailableWidth();
        this.setWindow(window);
        this.updateLogTag(params);
        this.mResizeShadowSize = context.getResources().getDimensionPixelSize(17105086);
        this.initResizingPaints();
    }

    void setBackgroundFallback(int resId) {
        this.mBackgroundFallback.setDrawable(resId != 0 ? this.getContext().getDrawable(resId) : null);
        this.setWillNotDraw(this.getBackground() == null && !this.mBackgroundFallback.hasFallback());
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean statusOpaque = this.gatherTransparentRegion(this.mStatusColorViewState, region);
        boolean navOpaque = this.gatherTransparentRegion(this.mNavigationColorViewState, region);
        boolean decorOpaque = super.gatherTransparentRegion(region);
        return statusOpaque || navOpaque || decorOpaque;
    }

    boolean gatherTransparentRegion(ColorViewState colorViewState, Region region) {
        if (colorViewState.view != null && colorViewState.visible && this.isResizing()) {
            return colorViewState.view.gatherTransparentRegion(region);
        }
        return false;
    }

    @Override
    public void onDraw(Canvas c) {
        super.onDraw(c);
        this.mBackgroundFallback.draw(this.mContentRoot, c, this.mWindow.mContentParent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean isDown;
        int keyCode = event.getKeyCode();
        int action = event.getAction();
        boolean bl = isDown = action == 0;
        if (isDown && event.getRepeatCount() == 0) {
            boolean handled;
            if (this.mWindow.mPanelChordingKey > 0 && this.mWindow.mPanelChordingKey != keyCode && (handled = this.dispatchKeyShortcutEvent(event))) {
                return true;
            }
            if (this.mWindow.mPreparedPanel != null && this.mWindow.mPreparedPanel.isOpen && this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, keyCode, event, 0)) {
                return true;
            }
        }
        if (!this.mWindow.isDestroyed()) {
            boolean handled;
            Window.Callback cb = this.mWindow.getCallback();
            boolean bl2 = handled = cb != null && this.mFeatureId < 0 ? cb.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
            if (handled) {
                return true;
            }
        }
        return isDown ? this.mWindow.onKeyDown(this.mFeatureId, event.getKeyCode(), event) : this.mWindow.onKeyUp(this.mFeatureId, event.getKeyCode(), event);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent ev) {
        boolean handled;
        if (this.mWindow.mPreparedPanel != null && (handled = this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
            if (this.mWindow.mPreparedPanel != null) {
                this.mWindow.mPreparedPanel.isHandled = true;
            }
            return true;
        }
        Window.Callback cb = this.mWindow.getCallback();
        boolean bl = handled = cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchKeyShortcutEvent(ev) : super.dispatchKeyShortcutEvent(ev);
        if (handled) {
            return true;
        }
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        if (st != null && this.mWindow.mPreparedPanel == null) {
            this.mWindow.preparePanel(st, ev);
            handled = this.mWindow.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
            st.isPrepared = false;
            if (handled) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTouchEvent(ev) : super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTrackballEvent(ev) : super.dispatchTrackballEvent(ev);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchGenericMotionEvent(ev) : super.dispatchGenericMotionEvent(ev);
    }

    public boolean superDispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4) {
            int action = event.getAction();
            if (this.mPrimaryActionMode != null) {
                if (action == 1) {
                    this.mPrimaryActionMode.finish();
                }
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
        return super.dispatchKeyShortcutEvent(event);
    }

    public boolean superDispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    public boolean superDispatchTrackballEvent(MotionEvent event) {
        return super.dispatchTrackballEvent(event);
    }

    public boolean superDispatchGenericMotionEvent(MotionEvent event) {
        return super.dispatchGenericMotionEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.onInterceptTouchEvent(event);
    }

    private boolean isOutOfInnerBounds(int x, int y) {
        return x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight();
    }

    private boolean isOutOfBounds(int x, int y) {
        return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        int y;
        int x;
        int action = event.getAction();
        if (this.mHasCaption && this.isShowingCaption() && action == 0 && this.isOutOfInnerBounds(x = (int)event.getX(), y = (int)event.getY())) {
            return true;
        }
        if (this.mFeatureId >= 0 && action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
            this.mWindow.closePanel(this.mFeatureId);
            return true;
        }
        return false;
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        if ((this.mFeatureId == 0 || this.mFeatureId == 6 || this.mFeatureId == 2 || this.mFeatureId == 5) && this.getChildCount() == 1) {
            this.getChildAt(0).sendAccessibilityEvent(eventType);
        } else {
            super.sendAccessibilityEvent(eventType);
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && cb.dispatchPopulateAccessibilityEvent(event)) {
            return true;
        }
        return super.dispatchPopulateAccessibilityEventInternal(event);
    }

    @Override
    protected boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        if (changed) {
            Drawable bg;
            Rect drawingBounds = this.mDrawingBounds;
            this.getDrawingRect(drawingBounds);
            Drawable fg = this.getForeground();
            if (fg != null) {
                Rect frameOffsets = this.mFrameOffsets;
                drawingBounds.left += frameOffsets.left;
                drawingBounds.top += frameOffsets.top;
                drawingBounds.right -= frameOffsets.right;
                drawingBounds.bottom -= frameOffsets.bottom;
                fg.setBounds(drawingBounds);
                Rect framePadding = this.mFramePadding;
                drawingBounds.left += framePadding.left - frameOffsets.left;
                drawingBounds.top += framePadding.top - frameOffsets.top;
                drawingBounds.right -= framePadding.right - frameOffsets.right;
                drawingBounds.bottom -= framePadding.bottom - frameOffsets.bottom;
            }
            if ((bg = this.getBackground()) != null) {
                bg.setBounds(drawingBounds);
            }
        }
        return changed;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mode;
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean fixedWidth = false;
        this.mApplyFloatingHorizontalInsets = false;
        if (widthMode == Integer.MIN_VALUE) {
            TypedValue tvw;
            TypedValue typedValue = tvw = isPortrait ? this.mWindow.mFixedWidthMinor : this.mWindow.mFixedWidthMajor;
            if (tvw != null && tvw.type != 0) {
                int w = tvw.type == 5 ? (int)tvw.getDimension(metrics) : (tvw.type == 6 ? (int)tvw.getFraction(metrics.widthPixels, metrics.widthPixels) : 0);
                int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
                if (w > 0) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(w, widthSize), 0x40000000);
                    fixedWidth = true;
                } else {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(widthSize - this.mFloatingInsets.left - this.mFloatingInsets.right, Integer.MIN_VALUE);
                    this.mApplyFloatingHorizontalInsets = true;
                }
            }
        }
        this.mApplyFloatingVerticalInsets = false;
        if (heightMode == Integer.MIN_VALUE) {
            TypedValue tvh;
            TypedValue typedValue = tvh = isPortrait ? this.mWindow.mFixedHeightMajor : this.mWindow.mFixedHeightMinor;
            if (tvh != null && tvh.type != 0) {
                int h = tvh.type == 5 ? (int)tvh.getDimension(metrics) : (tvh.type == 6 ? (int)tvh.getFraction(metrics.heightPixels, metrics.heightPixels) : 0);
                int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
                if (h > 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(h, heightSize), 0x40000000);
                } else if ((this.mWindow.getAttributes().flags & 0x100) == 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(heightSize - this.mFloatingInsets.top - this.mFloatingInsets.bottom, Integer.MIN_VALUE);
                    this.mApplyFloatingVerticalInsets = true;
                }
            }
        }
        this.getOutsets(this.mOutsets);
        if ((this.mOutsets.top > 0 || this.mOutsets.bottom > 0) && (mode = View.MeasureSpec.getMode(heightMeasureSpec)) != 0) {
            int height = View.MeasureSpec.getSize(heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height + this.mOutsets.top + this.mOutsets.bottom, mode);
        }
        if ((this.mOutsets.left > 0 || this.mOutsets.right > 0) && (mode = View.MeasureSpec.getMode(widthMeasureSpec)) != 0) {
            int width = View.MeasureSpec.getSize(widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width + this.mOutsets.left + this.mOutsets.right, mode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
            int min;
            TypedValue tv;
            TypedValue typedValue = tv = isPortrait ? this.mWindow.mMinWidthMinor : this.mWindow.mMinWidthMajor;
            if (tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction(this.mAvailableWidth, this.mAvailableWidth) : 0))) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(min, 0x40000000);
                measure = true;
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.getOutsets(this.mOutsets);
        if (this.mOutsets.left > 0) {
            this.offsetLeftAndRight(-this.mOutsets.left);
        }
        if (this.mOutsets.top > 0) {
            this.offsetTopAndBottom(-this.mOutsets.top);
        }
        if (this.mApplyFloatingVerticalInsets) {
            this.offsetTopAndBottom(this.mFloatingInsets.top);
        }
        if (this.mApplyFloatingHorizontalInsets) {
            this.offsetLeftAndRight(this.mFloatingInsets.left);
        }
        this.updateElevation();
        this.mAllowUpdateElevation = true;
        if (changed && this.mResizeMode == 1) {
            this.getViewRootImpl().requestInvalidateRootRenderNode();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mMenuBackground != null) {
            this.mMenuBackground.draw(canvas);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return this.showContextMenuForChildInternal(originalView, Float.NaN, Float.NaN);
    }

    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        return this.showContextMenuForChildInternal(originalView, x, y);
    }

    private boolean showContextMenuForChildInternal(View originalView, float x, float y) {
        if (this.mWindow.mContextMenuHelper != null) {
            this.mWindow.mContextMenuHelper.dismiss();
            this.mWindow.mContextMenuHelper = null;
        }
        PhoneWindow.PhoneWindowMenuCallback callback = this.mWindow.mContextMenuCallback;
        if (this.mWindow.mContextMenu == null) {
            this.mWindow.mContextMenu = new ContextMenuBuilder(this.getContext());
            this.mWindow.mContextMenu.setCallback(callback);
        } else {
            this.mWindow.mContextMenu.clearAll();
        }
        boolean isPopup = !Float.isNaN(x) && !Float.isNaN(y);
        MenuHelper helper = isPopup ? this.mWindow.mContextMenu.showPopup(this.getContext(), originalView, x, y) : this.mWindow.mContextMenu.showDialog(originalView, originalView.getWindowToken());
        if (helper != null) {
            callback.setShowDialogForSubmenu(!isPopup);
            helper.setPresenterCallback(callback);
        }
        this.mWindow.mContextMenuHelper = helper;
        return helper != null;
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return this.startActionModeForChild(originalView, callback, 0);
    }

    @Override
    public ActionMode startActionModeForChild(View child, ActionMode.Callback callback, int type) {
        return this.startActionMode(child, callback, type);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.startActionMode(callback, 0);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        return this.startActionMode(this, callback, type);
    }

    private ActionMode startActionMode(View originatingView, ActionMode.Callback callback, int type) {
        ActionMode mode;
        ActionModeCallback2Wrapper wrappedCallback;
        block16: {
            wrappedCallback = new ActionModeCallback2Wrapper(callback);
            mode = null;
            if (this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
                try {
                    mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback, type);
                }
                catch (AbstractMethodError ame) {
                    if (type != 0) break block16;
                    try {
                        mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
            }
        }
        if (mode != null) {
            if (mode.getType() == 0) {
                this.cleanupPrimaryActionMode();
                this.mPrimaryActionMode = mode;
            } else if (mode.getType() == 1) {
                if (this.mFloatingActionMode != null) {
                    this.mFloatingActionMode.finish();
                }
                this.mFloatingActionMode = mode;
            }
        } else {
            mode = this.createActionMode(type, wrappedCallback, originatingView);
            if (mode != null && wrappedCallback.onCreateActionMode(mode, mode.getMenu())) {
                this.setHandledActionMode(mode);
            } else {
                mode = null;
            }
        }
        if (mode != null && this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
            try {
                this.mWindow.getCallback().onActionModeStarted(mode);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return mode;
    }

    private void cleanupPrimaryActionMode() {
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.finish();
            this.mPrimaryActionMode = null;
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
        }
    }

    private void cleanupFloatingActionModeViews() {
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        if (this.mFloatingActionModeOriginatingView != null) {
            if (this.mFloatingToolbarPreDrawListener != null) {
                this.mFloatingActionModeOriginatingView.getViewTreeObserver().removeOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
                this.mFloatingToolbarPreDrawListener = null;
            }
            this.mFloatingActionModeOriginatingView = null;
        }
    }

    void startChanging() {
        this.mChanging = true;
    }

    void finishChanging() {
        this.mChanging = false;
        this.drawableChanged();
    }

    public void setWindowBackground(Drawable drawable2) {
        if (this.getBackground() != drawable2) {
            this.setBackgroundDrawable(drawable2);
            this.mResizingBackgroundDrawable = drawable2 != null ? DecorView.enforceNonTranslucentBackground(drawable2, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper()) : DecorView.getResizingBackgroundDrawable(this.getContext(), 0, this.mWindow.mBackgroundFallbackResource, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper());
            if (this.mResizingBackgroundDrawable != null) {
                this.mResizingBackgroundDrawable.getPadding(this.mBackgroundPadding);
            } else {
                this.mBackgroundPadding.setEmpty();
            }
            this.drawableChanged();
        }
    }

    public void setWindowFrame(Drawable drawable2) {
        if (this.getForeground() != drawable2) {
            this.setForeground(drawable2);
            if (drawable2 != null) {
                drawable2.getPadding(this.mFramePadding);
            } else {
                this.mFramePadding.setEmpty();
            }
            this.drawableChanged();
        }
    }

    @Override
    public void onWindowSystemUiVisibilityChanged(int visible) {
        this.updateColorViews(null, true);
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        this.mFloatingInsets.setEmpty();
        if ((attrs.flags & 0x100) == 0) {
            if (attrs.height == -2) {
                this.mFloatingInsets.top = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.bottom = insets.getSystemWindowInsetBottom();
                insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), 0, insets.getSystemWindowInsetRight(), 0);
            }
            if (this.mWindow.getAttributes().width == -2) {
                this.mFloatingInsets.left = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.right = insets.getSystemWindowInsetBottom();
                insets = insets.replaceSystemWindowInsets(0, insets.getSystemWindowInsetTop(), 0, insets.getSystemWindowInsetBottom());
            }
        }
        this.mFrameOffsets.set(insets.getSystemWindowInsets());
        insets = this.updateColorViews(insets, true);
        insets = this.updateStatusGuard(insets);
        this.updateNavigationGuard(insets);
        if (this.getForeground() != null) {
            this.drawableChanged();
        }
        return insets;
    }

    @Override
    public boolean isTransitionGroup() {
        return false;
    }

    static int getColorViewTopInset(int stableTop, int systemTop) {
        return Math.min(stableTop, systemTop);
    }

    static int getColorViewBottomInset(int stableBottom, int systemBottom) {
        return Math.min(stableBottom, systemBottom);
    }

    static int getColorViewRightInset(int stableRight, int systemRight) {
        return Math.min(stableRight, systemRight);
    }

    static boolean isNavBarToRightEdge(int bottomInset, int rightInset) {
        return bottomInset == 0 && rightInset > 0;
    }

    static int getNavBarSize(int bottomInset, int rightInset) {
        return DecorView.isNavBarToRightEdge(bottomInset, rightInset) ? rightInset : bottomInset;
    }

    WindowInsets updateColorViews(WindowInsets insets, boolean animate) {
        int consumedBottom;
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        int sysUiVisibility = attrs.systemUiVisibility | this.getWindowSystemUiVisibility();
        if (!this.mWindow.mIsFloating && ActivityManager.isHighEndGfx()) {
            boolean disallowAnimate = !this.isLaidOut();
            disallowAnimate |= ((this.mLastWindowFlags ^ attrs.flags) & Integer.MIN_VALUE) != 0;
            this.mLastWindowFlags = attrs.flags;
            if (insets != null) {
                this.mLastTopInset = DecorView.getColorViewTopInset(insets.getStableInsetTop(), insets.getSystemWindowInsetTop());
                this.mLastBottomInset = DecorView.getColorViewBottomInset(insets.getStableInsetBottom(), insets.getSystemWindowInsetBottom());
                this.mLastRightInset = DecorView.getColorViewRightInset(insets.getStableInsetRight(), insets.getSystemWindowInsetRight());
                boolean hasTopStableInset = insets.getStableInsetTop() != 0;
                disallowAnimate |= hasTopStableInset != this.mLastHasTopStableInset;
                this.mLastHasTopStableInset = hasTopStableInset;
                boolean hasBottomStableInset = insets.getStableInsetBottom() != 0;
                disallowAnimate |= hasBottomStableInset != this.mLastHasBottomStableInset;
                this.mLastHasBottomStableInset = hasBottomStableInset;
                boolean hasRightStableInset = insets.getStableInsetRight() != 0;
                disallowAnimate |= hasRightStableInset != this.mLastHasRightStableInset;
                this.mLastHasRightStableInset = hasRightStableInset;
                this.mLastShouldAlwaysConsumeNavBar = insets.shouldAlwaysConsumeNavBar();
            }
            boolean navBarToRightEdge = DecorView.isNavBarToRightEdge(this.mLastBottomInset, this.mLastRightInset);
            int navBarSize = DecorView.getNavBarSize(this.mLastBottomInset, this.mLastRightInset);
            this.updateColorViewInt(this.mNavigationColorViewState, sysUiVisibility, this.mWindow.mNavigationBarColor, navBarSize, navBarToRightEdge, 0, animate && !disallowAnimate, false);
            boolean statusBarNeedsRightInset = navBarToRightEdge && this.mNavigationColorViewState.present;
            int statusBarRightInset = statusBarNeedsRightInset ? this.mLastRightInset : 0;
            this.updateColorViewInt(this.mStatusColorViewState, sysUiVisibility, this.calculateStatusBarColor(), this.mLastTopInset, false, statusBarRightInset, animate && !disallowAnimate, this.mForceWindowDrawsStatusBarBackground);
        }
        boolean consumingNavBar = (attrs.flags & Integer.MIN_VALUE) != 0 && (sysUiVisibility & 0x200) == 0 && (sysUiVisibility & 2) == 0 || this.mLastShouldAlwaysConsumeNavBar;
        boolean consumingStatusBar = (sysUiVisibility & 0x400) == 0 && (sysUiVisibility & Integer.MIN_VALUE) == 0 && (attrs.flags & 0x100) == 0 && (attrs.flags & 0x10000) == 0 && this.mForceWindowDrawsStatusBarBackground && this.mLastTopInset != 0;
        int consumedTop = consumingStatusBar ? this.mLastTopInset : 0;
        int consumedRight = consumingNavBar ? this.mLastRightInset : 0;
        int n = consumedBottom = consumingNavBar ? this.mLastBottomInset : 0;
        if (this.mContentRoot != null && this.mContentRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mContentRoot.getLayoutParams();
            if (lp.topMargin != consumedTop || lp.rightMargin != consumedRight || lp.bottomMargin != consumedBottom) {
                lp.topMargin = consumedTop;
                lp.rightMargin = consumedRight;
                lp.bottomMargin = consumedBottom;
                this.mContentRoot.setLayoutParams(lp);
                if (insets == null) {
                    this.requestApplyInsets();
                }
            }
            if (insets != null) {
                insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop() - consumedTop, insets.getSystemWindowInsetRight() - consumedRight, insets.getSystemWindowInsetBottom() - consumedBottom);
            }
        }
        if (insets != null) {
            insets = insets.consumeStableInsets();
        }
        return insets;
    }

    private int calculateStatusBarColor() {
        int flags = this.mWindow.getAttributes().flags;
        return (flags & 0x4000000) != 0 ? this.mSemiTransparentStatusBarColor : ((flags & Integer.MIN_VALUE) != 0 ? this.mWindow.mStatusBarColor : -16777216);
    }

    private int getCurrentColor(ColorViewState state) {
        if (state.visible) {
            return state.color;
        }
        return 0;
    }

    private void updateColorViewInt(final ColorViewState state, int sysUiVis, int color2, int size, boolean verticalBar, int rightMargin, boolean animate, boolean force) {
        int resolvedGravity;
        state.present = (sysUiVis & state.systemUiHideFlag) == 0 && (this.mWindow.getAttributes().flags & state.hideWindowFlag) == 0 && ((this.mWindow.getAttributes().flags & Integer.MIN_VALUE) != 0 || force);
        boolean show = state.present && (color2 & 0xFF000000) != 0 && ((this.mWindow.getAttributes().flags & state.translucentFlag) == 0 || force);
        boolean showView = show && !this.isResizing() && size > 0;
        boolean visibilityChanged = false;
        View view = state.view;
        int resolvedHeight = verticalBar ? -1 : size;
        int resolvedWidth = verticalBar ? size : -1;
        int n = resolvedGravity = verticalBar ? state.horizontalGravity : state.verticalGravity;
        if (view == null) {
            if (showView) {
                state.view = view = new View(this.mContext);
                view.setBackgroundColor(color2);
                view.setTransitionName(state.transitionName);
                view.setId(state.id);
                visibilityChanged = true;
                view.setVisibility(4);
                state.targetVisibility = 0;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(resolvedWidth, resolvedHeight, resolvedGravity);
                lp.rightMargin = rightMargin;
                this.addView(view, lp);
                this.updateColorViewTranslations();
            }
        } else {
            int vis = showView ? 0 : 4;
            visibilityChanged = state.targetVisibility != vis;
            state.targetVisibility = vis;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
            if (lp.height != resolvedHeight || lp.width != resolvedWidth || lp.gravity != resolvedGravity || lp.rightMargin != rightMargin) {
                lp.height = resolvedHeight;
                lp.width = resolvedWidth;
                lp.gravity = resolvedGravity;
                lp.rightMargin = rightMargin;
                view.setLayoutParams(lp);
            }
            if (showView) {
                view.setBackgroundColor(color2);
            }
        }
        if (visibilityChanged) {
            view.animate().cancel();
            if (animate && !this.isResizing()) {
                if (showView) {
                    if (view.getVisibility() != 0) {
                        view.setVisibility(0);
                        view.setAlpha(0.0f);
                    }
                    view.animate().alpha(1.0f).setInterpolator(this.mShowInterpolator).setDuration(this.mBarEnterExitDuration);
                } else {
                    view.animate().alpha(0.0f).setInterpolator(this.mHideInterpolator).setDuration(this.mBarEnterExitDuration).withEndAction(new Runnable(){

                        @Override
                        public void run() {
                            state.view.setAlpha(1.0f);
                            state.view.setVisibility(4);
                        }
                    });
                }
            } else {
                view.setAlpha(1.0f);
                view.setVisibility(showView ? 0 : 4);
            }
        }
        state.visible = show;
        state.color = color2;
    }

    private void updateColorViewTranslations() {
        int rootScrollY = this.mRootScrollY;
        if (this.mStatusColorViewState.view != null) {
            this.mStatusColorViewState.view.setTranslationY(rootScrollY > 0 ? (float)rootScrollY : 0.0f);
        }
        if (this.mNavigationColorViewState.view != null) {
            this.mNavigationColorViewState.view.setTranslationY(rootScrollY < 0 ? (float)rootScrollY : 0.0f);
        }
    }

    private WindowInsets updateStatusGuard(WindowInsets insets) {
        boolean showStatusGuard = false;
        if (this.mPrimaryActionModeView != null && this.mPrimaryActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mPrimaryActionModeView.getLayoutParams();
            boolean mlpChanged = false;
            if (this.mPrimaryActionModeView.isShown()) {
                int newMargin;
                if (this.mTempRect == null) {
                    this.mTempRect = new Rect();
                }
                Rect rect = this.mTempRect;
                this.mWindow.mContentParent.computeSystemWindowInsets(insets, rect);
                int n = newMargin = rect.top == 0 ? insets.getSystemWindowInsetTop() : 0;
                if (mlp.topMargin != newMargin) {
                    mlpChanged = true;
                    mlp.topMargin = insets.getSystemWindowInsetTop();
                    if (this.mStatusGuard == null) {
                        this.mStatusGuard = new View(this.mContext);
                        this.mStatusGuard.setBackgroundColor(this.mContext.getColor(17170482));
                        this.addView(this.mStatusGuard, this.indexOfChild(this.mStatusColorViewState.view), new FrameLayout.LayoutParams(-1, mlp.topMargin, 0x800033));
                    } else {
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mStatusGuard.getLayoutParams();
                        if (lp.height != mlp.topMargin) {
                            lp.height = mlp.topMargin;
                            this.mStatusGuard.setLayoutParams(lp);
                        }
                    }
                }
                showStatusGuard = this.mStatusGuard != null;
                boolean nonOverlay = (this.mWindow.getLocalFeaturesPrivate() & 0x400) == 0;
                insets = insets.consumeSystemWindowInsets(false, nonOverlay && showStatusGuard, false, false);
            } else if (mlp.topMargin != 0) {
                mlpChanged = true;
                mlp.topMargin = 0;
            }
            if (mlpChanged) {
                this.mPrimaryActionModeView.setLayoutParams(mlp);
            }
        }
        if (this.mStatusGuard != null) {
            this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
        }
        return insets;
    }

    private void updateNavigationGuard(WindowInsets insets) {
        if (this.mWindow.getAttributes().type == 2011) {
            if (this.mWindow.mContentParent != null && this.mWindow.mContentParent.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mWindow.mContentParent.getLayoutParams();
                mlp.bottomMargin = insets.getSystemWindowInsetBottom();
                this.mWindow.mContentParent.setLayoutParams(mlp);
            }
            if (this.mNavigationGuard == null) {
                this.mNavigationGuard = new View(this.mContext);
                this.mNavigationGuard.setBackgroundColor(this.mContext.getColor(17170482));
                this.addView(this.mNavigationGuard, this.indexOfChild(this.mNavigationColorViewState.view), new FrameLayout.LayoutParams(-1, insets.getSystemWindowInsetBottom(), 8388691));
            } else {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mNavigationGuard.getLayoutParams();
                lp.height = insets.getSystemWindowInsetBottom();
                this.mNavigationGuard.setLayoutParams(lp);
            }
            this.updateNavigationGuardColor();
        }
    }

    void updateNavigationGuardColor() {
        if (this.mNavigationGuard != null) {
            this.mNavigationGuard.setVisibility(this.mWindow.getNavigationBarColor() == 0 ? 4 : 0);
        }
    }

    private void drawableChanged() {
        if (this.mChanging) {
            return;
        }
        this.setPadding(this.mFramePadding.left + this.mBackgroundPadding.left, this.mFramePadding.top + this.mBackgroundPadding.top, this.mFramePadding.right + this.mBackgroundPadding.right, this.mFramePadding.bottom + this.mBackgroundPadding.bottom);
        this.requestLayout();
        this.invalidate();
        int opacity = -1;
        if (ActivityManager.StackId.hasWindowShadow(this.mStackId)) {
            opacity = -3;
        } else {
            Drawable bg = this.getBackground();
            Drawable fg = this.getForeground();
            if (bg != null) {
                if (fg == null) {
                    opacity = bg.getOpacity();
                } else if (this.mFramePadding.left <= 0 && this.mFramePadding.top <= 0 && this.mFramePadding.right <= 0 && this.mFramePadding.bottom <= 0) {
                    int fop = fg.getOpacity();
                    int bop = bg.getOpacity();
                    opacity = fop == -1 || bop == -1 ? -1 : (fop == 0 ? bop : (bop == 0 ? fop : Drawable.resolveOpacity(fop, bop)));
                } else {
                    opacity = -3;
                }
            }
        }
        this.mDefaultOpacity = opacity;
        if (this.mFeatureId < 0) {
            this.mWindow.setDefaultWindowFormat(opacity);
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        Window.Callback cb;
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mWindow.hasFeature(0) && !hasWindowFocus && this.mWindow.mPanelChordingKey != 0) {
            this.mWindow.closePanel(0);
        }
        if ((cb = this.mWindow.getCallback()) != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        this.updateElevation();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onAttachedToWindow();
        }
        if (this.mFeatureId == -1) {
            this.mWindow.openPanelsAfterRestore();
        }
        if (!this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().addWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = true;
        } else if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.onConfigurationChange();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        PhoneWindow.PanelFeatureState st;
        super.onDetachedFromWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && this.mFeatureId < 0) {
            cb.onDetachedFromWindow();
        }
        if (this.mWindow.mDecorContentParent != null) {
            this.mWindow.mDecorContentParent.dismissPopups();
        }
        if (this.mPrimaryActionModePopup != null) {
            this.removeCallbacks(this.mShowPrimaryActionModePopup);
            if (this.mPrimaryActionModePopup.isShowing()) {
                this.mPrimaryActionModePopup.dismiss();
            }
            this.mPrimaryActionModePopup = null;
        }
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        if ((st = this.mWindow.getPanelState(0, false)) != null && st.menu != null && this.mFeatureId < 0) {
            st.menu.close();
        }
        this.releaseThreadedRenderer();
        if (this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().removeWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = false;
        }
    }

    @Override
    public void onCloseSystemDialogs(String reason) {
        if (this.mFeatureId >= 0) {
            this.mWindow.closeAllPanels();
        }
    }

    @Override
    public SurfaceHolder.Callback2 willYouTakeTheSurface() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeSurfaceCallback : null;
    }

    @Override
    public InputQueue.Callback willYouTakeTheInputQueue() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeInputQueueCallback : null;
    }

    @Override
    public void setSurfaceType(int type) {
        this.mWindow.setType(type);
    }

    @Override
    public void setSurfaceFormat(int format) {
        this.mWindow.setFormat(format);
    }

    @Override
    public void setSurfaceKeepScreenOn(boolean keepOn) {
        if (keepOn) {
            this.mWindow.addFlags(128);
        } else {
            this.mWindow.clearFlags(128);
        }
    }

    @Override
    public void onRootViewScrollYChanged(int rootScrollY) {
        this.mRootScrollY = rootScrollY;
        this.updateColorViewTranslations();
    }

    private ActionMode createActionMode(int type, ActionMode.Callback2 callback, View originatingView) {
        switch (type) {
            default: {
                return this.createStandaloneActionMode(callback);
            }
            case 1: 
        }
        return this.createFloatingActionMode(originatingView, callback);
    }

    private void setHandledActionMode(ActionMode mode) {
        if (mode.getType() == 0) {
            this.setHandledPrimaryActionMode(mode);
        } else if (mode.getType() == 1) {
            this.setHandledFloatingActionMode(mode);
        }
    }

    private ActionMode createStandaloneActionMode(ActionMode.Callback callback) {
        this.endOnGoingFadeAnimation();
        this.cleanupPrimaryActionMode();
        if (this.mPrimaryActionModeView == null || !this.mPrimaryActionModeView.isAttachedToWindow()) {
            if (this.mWindow.isFloating()) {
                Context actionBarContext;
                TypedValue outValue = new TypedValue();
                Resources.Theme baseTheme = this.mContext.getTheme();
                baseTheme.resolveAttribute(16843825, outValue, true);
                if (outValue.resourceId != 0) {
                    Resources.Theme actionBarTheme = this.mContext.getResources().newTheme();
                    actionBarTheme.setTo(baseTheme);
                    actionBarTheme.applyStyle(outValue.resourceId, true);
                    actionBarContext = new ContextThemeWrapper(this.mContext, 0);
                    actionBarContext.getTheme().setTo(actionBarTheme);
                } else {
                    actionBarContext = this.mContext;
                }
                this.mPrimaryActionModeView = new ActionBarContextView(actionBarContext);
                this.mPrimaryActionModePopup = new PopupWindow(actionBarContext, null, 18219038);
                this.mPrimaryActionModePopup.setWindowLayoutType(2);
                this.mPrimaryActionModePopup.setContentView(this.mPrimaryActionModeView);
                this.mPrimaryActionModePopup.setWidth(-1);
                actionBarContext.getTheme().resolveAttribute(16843499, outValue, true);
                int height = TypedValue.complexToDimensionPixelSize(outValue.data, actionBarContext.getResources().getDisplayMetrics());
                this.mPrimaryActionModeView.setContentHeight(height);
                this.mPrimaryActionModePopup.setHeight(-2);
                this.mShowPrimaryActionModePopup = new Runnable(){

                    @Override
                    public void run() {
                        DecorView.this.mPrimaryActionModePopup.showAtLocation(DecorView.this.mPrimaryActionModeView.getApplicationWindowToken(), 55, 0, 0);
                        DecorView.this.endOnGoingFadeAnimation();
                        if (DecorView.this.shouldAnimatePrimaryActionModeView()) {
                            DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
                            DecorView.this.mFadeAnim.addListener(new AnimatorListenerAdapter(){

                                @Override
                                public void onAnimationStart(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setVisibility(0);
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                                    DecorView.this.mFadeAnim = null;
                                }
                            });
                            DecorView.this.mFadeAnim.start();
                        } else {
                            DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                            DecorView.this.mPrimaryActionModeView.setVisibility(0);
                        }
                    }
                };
            } else {
                ViewStub stub = (ViewStub)this.findViewById(16909288);
                if (stub != null) {
                    this.mPrimaryActionModeView = (ActionBarContextView)stub.inflate();
                    this.mPrimaryActionModePopup = null;
                }
            }
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
            StandaloneActionMode mode = new StandaloneActionMode(this.mPrimaryActionModeView.getContext(), this.mPrimaryActionModeView, callback, this.mPrimaryActionModePopup == null);
            return mode;
        }
        return null;
    }

    private void endOnGoingFadeAnimation() {
        if (this.mFadeAnim != null) {
            this.mFadeAnim.end();
        }
    }

    private void setHandledPrimaryActionMode(ActionMode mode) {
        this.endOnGoingFadeAnimation();
        this.mPrimaryActionMode = mode;
        this.mPrimaryActionMode.invalidate();
        this.mPrimaryActionModeView.initForMode(this.mPrimaryActionMode);
        if (this.mPrimaryActionModePopup != null) {
            this.post(this.mShowPrimaryActionModePopup);
        } else if (this.shouldAnimatePrimaryActionModeView()) {
            this.mFadeAnim = ObjectAnimator.ofFloat(this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
            this.mFadeAnim.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    DecorView.this.mPrimaryActionModeView.setVisibility(0);
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    DecorView.this.mPrimaryActionModeView.setAlpha(1.0f);
                    DecorView.this.mFadeAnim = null;
                }
            });
            this.mFadeAnim.start();
        } else {
            this.mPrimaryActionModeView.setAlpha(1.0f);
            this.mPrimaryActionModeView.setVisibility(0);
        }
        this.mPrimaryActionModeView.sendAccessibilityEvent(32);
    }

    boolean shouldAnimatePrimaryActionModeView() {
        return this.isLaidOut();
    }

    private ActionMode createFloatingActionMode(View originatingView, ActionMode.Callback2 callback) {
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.finish();
        }
        this.cleanupFloatingActionModeViews();
        final FloatingActionMode mode = new FloatingActionMode(this.mContext, callback, originatingView);
        this.mFloatingActionModeOriginatingView = originatingView;
        this.mFloatingToolbarPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                mode.updateViewLocationInWindow();
                return true;
            }
        };
        return mode;
    }

    private void setHandledFloatingActionMode(ActionMode mode) {
        this.mFloatingActionMode = mode;
        this.mFloatingToolbar = new FloatingToolbar(this.mContext, this.mWindow);
        ((FloatingActionMode)this.mFloatingActionMode).setFloatingToolbar(this.mFloatingToolbar);
        this.mFloatingActionMode.invalidate();
        this.mFloatingActionModeOriginatingView.getViewTreeObserver().addOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
    }

    void enableCaption(boolean attachedAndVisible) {
        if (this.mHasCaption != attachedAndVisible) {
            this.mHasCaption = attachedAndVisible;
            if (this.getForeground() != null) {
                this.drawableChanged();
            }
        }
    }

    void setWindow(PhoneWindow phoneWindow) {
        this.mWindow = phoneWindow;
        Context context = this.getContext();
        if (context instanceof DecorContext) {
            DecorContext decorContext = (DecorContext)context;
            decorContext.setPhoneWindow(this.mWindow);
        }
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int workspaceId = this.getStackId();
        if (this.mStackId != workspaceId) {
            this.mStackId = workspaceId;
            if (this.mDecorCaptionView == null && ActivityManager.StackId.hasWindowDecor(this.mStackId)) {
                LayoutInflater inflater = this.mWindow.getLayoutInflater();
                this.mDecorCaptionView = this.createDecorCaptionView(inflater);
                if (this.mDecorCaptionView != null) {
                    if (this.mDecorCaptionView.getParent() == null) {
                        this.addView((View)this.mDecorCaptionView, 0, new ViewGroup.LayoutParams(-1, -1));
                    }
                    this.removeView(this.mContentRoot);
                    this.mDecorCaptionView.addView((View)this.mContentRoot, new ViewGroup.MarginLayoutParams(-1, -1));
                }
            } else if (this.mDecorCaptionView != null) {
                this.mDecorCaptionView.onConfigurationChanged(ActivityManager.StackId.hasWindowDecor(this.mStackId));
                this.enableCaption(ActivityManager.StackId.hasWindowDecor(workspaceId));
            }
        }
        this.updateAvailableWidth();
        this.initializeElevation();
    }

    void onResourcesLoaded(LayoutInflater inflater, int layoutResource) {
        this.mStackId = this.getStackId();
        if (this.mBackdropFrameRenderer != null) {
            this.loadBackgroundDrawablesIfNeeded();
            this.mBackdropFrameRenderer.onResourcesLoaded(this, this.mResizingBackgroundDrawable, this.mCaptionBackgroundDrawable, this.mUserCaptionBackgroundDrawable, this.getCurrentColor(this.mStatusColorViewState), this.getCurrentColor(this.mNavigationColorViewState));
        }
        this.mDecorCaptionView = this.createDecorCaptionView(inflater);
        View root = inflater.inflate(layoutResource, null);
        if (this.mDecorCaptionView != null) {
            if (this.mDecorCaptionView.getParent() == null) {
                this.addView((View)this.mDecorCaptionView, new ViewGroup.LayoutParams(-1, -1));
            }
            this.mDecorCaptionView.addView(root, new ViewGroup.MarginLayoutParams(-1, -1));
        } else {
            this.addView(root, 0, new ViewGroup.LayoutParams(-1, -1));
        }
        this.mContentRoot = (ViewGroup)root;
        this.initializeElevation();
    }

    private void loadBackgroundDrawablesIfNeeded() {
        if (this.mResizingBackgroundDrawable == null) {
            this.mResizingBackgroundDrawable = DecorView.getResizingBackgroundDrawable(this.getContext(), this.mWindow.mBackgroundResource, this.mWindow.mBackgroundFallbackResource, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper());
            if (this.mResizingBackgroundDrawable == null) {
                Log.w(this.mLogTag, "Failed to find background drawable for PhoneWindow=" + this.mWindow);
            }
        }
        if (this.mCaptionBackgroundDrawable == null) {
            this.mCaptionBackgroundDrawable = this.getContext().getDrawable(17302101);
        }
        if (this.mResizingBackgroundDrawable != null) {
            this.mLastBackgroundDrawableCb = this.mResizingBackgroundDrawable.getCallback();
            this.mResizingBackgroundDrawable.setCallback(null);
        }
    }

    private DecorCaptionView createDecorCaptionView(LayoutInflater inflater) {
        boolean isApplication;
        DecorCaptionView decorCaptionView = null;
        for (int i = this.getChildCount() - 1; i >= 0 && decorCaptionView == null; --i) {
            View view = this.getChildAt(i);
            if (!(view instanceof DecorCaptionView)) continue;
            decorCaptionView = (DecorCaptionView)view;
            this.removeViewAt(i);
        }
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        boolean bl = isApplication = attrs.type == 1 || attrs.type == 2;
        if (!this.mWindow.isFloating() && isApplication && ActivityManager.StackId.hasWindowDecor(this.mStackId)) {
            if (decorCaptionView == null) {
                decorCaptionView = this.inflateDecorCaptionView(inflater);
            }
            decorCaptionView.setPhoneWindow(this.mWindow, true);
        } else {
            decorCaptionView = null;
        }
        this.enableCaption(decorCaptionView != null);
        return decorCaptionView;
    }

    private DecorCaptionView inflateDecorCaptionView(LayoutInflater inflater) {
        Context context = this.getContext();
        inflater = LayoutInflater.from(context);
        DecorCaptionView view = (DecorCaptionView)inflater.inflate(17367119, null);
        this.setDecorCaptionShade(context, view);
        return view;
    }

    private void setDecorCaptionShade(Context context, DecorCaptionView view) {
        int shade = this.mWindow.getDecorCaptionShade();
        switch (shade) {
            case 1: {
                this.setLightDecorCaptionShade(view);
                break;
            }
            case 2: {
                this.setDarkDecorCaptionShade(view);
                break;
            }
            default: {
                TypedValue value = new TypedValue();
                context.getTheme().resolveAttribute(16843827, value, true);
                if ((double)Color.luminance(value.data) < 0.5) {
                    this.setLightDecorCaptionShade(view);
                    break;
                }
                this.setDarkDecorCaptionShade(view);
                break;
            }
        }
    }

    void updateDecorCaptionShade() {
        if (this.mDecorCaptionView != null) {
            this.setDecorCaptionShade(this.getContext(), this.mDecorCaptionView);
        }
    }

    private void setLightDecorCaptionShade(DecorCaptionView view) {
        view.findViewById(16909150).setBackgroundResource(17302106);
        view.findViewById(16909151).setBackgroundResource(17302104);
    }

    private void setDarkDecorCaptionShade(DecorCaptionView view) {
        view.findViewById(16909150).setBackgroundResource(17302105);
        view.findViewById(16909151).setBackgroundResource(17302103);
    }

    public static Drawable getResizingBackgroundDrawable(Context context, int backgroundRes, int backgroundFallbackRes, boolean windowTranslucent) {
        Drawable fallbackDrawable;
        Drawable drawable2;
        if (backgroundRes != 0 && (drawable2 = context.getDrawable(backgroundRes)) != null) {
            return DecorView.enforceNonTranslucentBackground(drawable2, windowTranslucent);
        }
        if (backgroundFallbackRes != 0 && (fallbackDrawable = context.getDrawable(backgroundFallbackRes)) != null) {
            return DecorView.enforceNonTranslucentBackground(fallbackDrawable, windowTranslucent);
        }
        return new ColorDrawable(-16777216);
    }

    private static Drawable enforceNonTranslucentBackground(Drawable drawable2, boolean windowTranslucent) {
        ColorDrawable colorDrawable;
        int color2;
        if (!windowTranslucent && drawable2 instanceof ColorDrawable && Color.alpha(color2 = (colorDrawable = (ColorDrawable)drawable2).getColor()) != 255) {
            ColorDrawable copy = (ColorDrawable)colorDrawable.getConstantState().newDrawable().mutate();
            copy.setColor(Color.argb(255, Color.red(color2), Color.green(color2), Color.blue(color2)));
            return copy;
        }
        return drawable2;
    }

    private int getStackId() {
        int workspaceId = -1;
        Window.WindowControllerCallback callback = this.mWindow.getWindowControllerCallback();
        if (callback != null) {
            try {
                workspaceId = callback.getWindowStackId();
            }
            catch (RemoteException ex) {
                Log.e(this.mLogTag, "Failed to get the workspace ID of a PhoneWindow.");
            }
        }
        if (workspaceId == -1) {
            return 1;
        }
        return workspaceId;
    }

    void clearContentView() {
        if (this.mDecorCaptionView != null) {
            this.mDecorCaptionView.removeContentView();
        } else {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                if (v == this.mStatusColorViewState.view || v == this.mNavigationColorViewState.view || v == this.mStatusGuard || v == this.mNavigationGuard) continue;
                this.removeViewAt(i);
            }
        }
    }

    @Override
    public void onWindowSizeIsChanging(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.setTargetRect(newBounds, fullscreen, systemInsets, stableInsets);
        }
    }

    @Override
    public void onWindowDragResizeStart(Rect initialBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets, int resizeMode) {
        if (this.mWindow.isDestroyed()) {
            this.releaseThreadedRenderer();
            return;
        }
        if (this.mBackdropFrameRenderer != null) {
            return;
        }
        ThreadedRenderer renderer = this.getHardwareRenderer();
        if (renderer != null) {
            this.loadBackgroundDrawablesIfNeeded();
            this.mBackdropFrameRenderer = new BackdropFrameRenderer(this, renderer, initialBounds, this.mResizingBackgroundDrawable, this.mCaptionBackgroundDrawable, this.mUserCaptionBackgroundDrawable, this.getCurrentColor(this.mStatusColorViewState), this.getCurrentColor(this.mNavigationColorViewState), fullscreen, systemInsets, stableInsets, resizeMode);
            this.updateElevation();
            this.updateColorViews(null, false);
        }
        this.mResizeMode = resizeMode;
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    @Override
    public void onWindowDragResizeEnd() {
        this.releaseThreadedRenderer();
        this.updateColorViews(null, false);
        this.mResizeMode = -1;
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    @Override
    public boolean onContentDrawn(int offsetX, int offsetY, int sizeX, int sizeY) {
        if (this.mBackdropFrameRenderer == null) {
            return false;
        }
        return this.mBackdropFrameRenderer.onContentDrawn(offsetX, offsetY, sizeX, sizeY);
    }

    @Override
    public void onRequestDraw(boolean reportNextDraw) {
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.onRequestDraw(reportNextDraw);
        } else if (reportNextDraw && this.isAttachedToWindow()) {
            this.getViewRootImpl().reportDrawFinish();
        }
    }

    @Override
    public void onPostDraw(DisplayListCanvas canvas) {
        this.drawResizingShadowIfNeeded(canvas);
    }

    private void initResizingPaints() {
        int startColor = this.mContext.getResources().getColor(17170547, null);
        int endColor = this.mContext.getResources().getColor(17170548, null);
        int middleColor = (startColor + endColor) / 2;
        this.mHorizontalResizeShadowPaint.setShader(new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.mResizeShadowSize, new int[]{startColor, middleColor, endColor}, new float[]{0.0f, 0.3f, 1.0f}, Shader.TileMode.CLAMP));
        this.mVerticalResizeShadowPaint.setShader(new LinearGradient(0.0f, 0.0f, (float)this.mResizeShadowSize, 0.0f, new int[]{startColor, middleColor, endColor}, new float[]{0.0f, 0.3f, 1.0f}, Shader.TileMode.CLAMP));
    }

    private void drawResizingShadowIfNeeded(DisplayListCanvas canvas) {
        if (this.mResizeMode != 1 || this.mWindow.mIsFloating || this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper()) {
            return;
        }
        canvas.save();
        canvas.translate(0.0f, this.getHeight() - this.mFrameOffsets.bottom);
        canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.mResizeShadowSize, this.mHorizontalResizeShadowPaint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.getWidth() - this.mFrameOffsets.right, 0.0f);
        canvas.drawRect(0.0f, 0.0f, this.mResizeShadowSize, this.getHeight(), this.mVerticalResizeShadowPaint);
        canvas.restore();
    }

    private void releaseThreadedRenderer() {
        if (this.mResizingBackgroundDrawable != null && this.mLastBackgroundDrawableCb != null) {
            this.mResizingBackgroundDrawable.setCallback(this.mLastBackgroundDrawableCb);
            this.mLastBackgroundDrawableCb = null;
        }
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.releaseRenderer();
            this.mBackdropFrameRenderer = null;
            this.updateElevation();
        }
    }

    private boolean isResizing() {
        return this.mBackdropFrameRenderer != null;
    }

    private void initializeElevation() {
        this.mAllowUpdateElevation = false;
        this.updateElevation();
    }

    private void updateElevation() {
        float elevation = 0.0f;
        boolean wasAdjustedForStack = this.mElevationAdjustedForStack;
        if (ActivityManager.StackId.hasWindowShadow(this.mStackId) && !this.isResizing()) {
            float f = elevation = this.hasWindowFocus() ? 20.0f : 5.0f;
            if (!this.mAllowUpdateElevation && this.mStackId != 4) {
                elevation = 20.0f;
            }
            elevation = this.dipToPx(elevation);
            this.mElevationAdjustedForStack = true;
        } else {
            this.mElevationAdjustedForStack = false;
        }
        if ((wasAdjustedForStack || this.mElevationAdjustedForStack) && this.getElevation() != elevation) {
            this.mWindow.setElevation(elevation);
        }
    }

    boolean isShowingCaption() {
        return this.mDecorCaptionView != null && this.mDecorCaptionView.isCaptionShowing();
    }

    int getCaptionHeight() {
        return this.isShowingCaption() ? this.mDecorCaptionView.getCaptionHeight() : 0;
    }

    private float dipToPx(float dip) {
        return TypedValue.applyDimension(1, dip, this.getResources().getDisplayMetrics());
    }

    void setUserCaptionBackgroundDrawable(Drawable drawable2) {
        this.mUserCaptionBackgroundDrawable = drawable2;
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.setUserCaptionBackgroundDrawable(drawable2);
        }
    }

    private static String getTitleSuffix(WindowManager.LayoutParams params) {
        if (params == null) {
            return "";
        }
        String[] split = params.getTitle().toString().split("\\.");
        if (split.length > 0) {
            return split[split.length - 1];
        }
        return "";
    }

    void updateLogTag(WindowManager.LayoutParams params) {
        this.mLogTag = "DecorView[" + DecorView.getTitleSuffix(params) + "]";
    }

    private void updateAvailableWidth() {
        Resources res = this.getResources();
        this.mAvailableWidth = TypedValue.applyDimension(1, res.getConfiguration().screenWidthDp, res.getDisplayMetrics());
    }

    @Override
    public void requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int deviceId) {
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        if (!this.mWindow.isDestroyed() && st != null && this.mWindow.getCallback() != null) {
            this.mWindow.getCallback().onProvideKeyboardShortcuts(list, st.menu, deviceId);
        }
    }

    @Override
    public String toString() {
        return "DecorView@" + Integer.toHexString(this.hashCode()) + "[" + DecorView.getTitleSuffix(this.mWindow.getAttributes()) + "]";
    }

    private class ActionModeCallback2Wrapper
    extends ActionMode.Callback2 {
        private final ActionMode.Callback mWrapped;

        public ActionModeCallback2Wrapper(ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onCreateActionMode(mode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            DecorView.this.requestFitSystemWindows();
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            boolean isFloating;
            boolean isPrimary;
            boolean isMncApp;
            this.mWrapped.onDestroyActionMode(mode);
            boolean bl = isMncApp = ((DecorView)DecorView.this).mContext.getApplicationInfo().targetSdkVersion >= 23;
            if (isMncApp) {
                isPrimary = mode == DecorView.this.mPrimaryActionMode;
                boolean bl2 = isFloating = mode == DecorView.this.mFloatingActionMode;
                if (!isPrimary && mode.getType() == 0) {
                    Log.e(DecorView.this.mLogTag, "Destroying unexpected ActionMode instance of TYPE_PRIMARY; " + mode + " was not the current primary action mode! Expected " + DecorView.this.mPrimaryActionMode);
                }
                if (!isFloating && mode.getType() == 1) {
                    Log.e(DecorView.this.mLogTag, "Destroying unexpected ActionMode instance of TYPE_FLOATING; " + mode + " was not the current floating action mode! Expected " + DecorView.this.mFloatingActionMode);
                }
            } else {
                isPrimary = mode.getType() == 0;
                boolean bl3 = isFloating = mode.getType() == 1;
            }
            if (isPrimary) {
                if (DecorView.this.mPrimaryActionModePopup != null) {
                    DecorView.this.removeCallbacks(DecorView.this.mShowPrimaryActionModePopup);
                }
                if (DecorView.this.mPrimaryActionModeView != null) {
                    DecorView.this.endOnGoingFadeAnimation();
                    final ActionBarContextView lastActionModeView = DecorView.this.mPrimaryActionModeView;
                    DecorView.this.mFadeAnim = ObjectAnimator.ofFloat(DecorView.this.mPrimaryActionModeView, View.ALPHA, 1.0f, 0.0f);
                    DecorView.this.mFadeAnim.addListener(new Animator.AnimatorListener(){

                        @Override
                        public void onAnimationStart(Animator animation) {
                        }

                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (lastActionModeView == DecorView.this.mPrimaryActionModeView) {
                                lastActionModeView.setVisibility(8);
                                if (DecorView.this.mPrimaryActionModePopup != null) {
                                    DecorView.this.mPrimaryActionModePopup.dismiss();
                                }
                                lastActionModeView.killMode();
                                DecorView.this.mFadeAnim = null;
                            }
                        }

                        @Override
                        public void onAnimationCancel(Animator animation) {
                        }

                        @Override
                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    DecorView.this.mFadeAnim.start();
                }
                DecorView.this.mPrimaryActionMode = null;
            } else if (isFloating) {
                DecorView.this.cleanupFloatingActionModeViews();
                DecorView.this.mFloatingActionMode = null;
            }
            if (DecorView.this.mWindow.getCallback() != null && !DecorView.this.mWindow.isDestroyed()) {
                try {
                    DecorView.this.mWindow.getCallback().onActionModeFinished(mode);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            DecorView.this.requestFitSystemWindows();
        }

        @Override
        public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
            if (this.mWrapped instanceof ActionMode.Callback2) {
                ((ActionMode.Callback2)this.mWrapped).onGetContentRect(mode, view, outRect);
            } else {
                super.onGetContentRect(mode, view, outRect);
            }
        }
    }

    private static class ColorViewState {
        View view = null;
        int targetVisibility = 4;
        boolean present = false;
        boolean visible;
        int color;
        final int id;
        final int systemUiHideFlag;
        final int translucentFlag;
        final int verticalGravity;
        final int horizontalGravity;
        final String transitionName;
        final int hideWindowFlag;

        ColorViewState(int systemUiHideFlag, int translucentFlag, int verticalGravity, int horizontalGravity, String transitionName, int id2, int hideWindowFlag) {
            this.id = id2;
            this.systemUiHideFlag = systemUiHideFlag;
            this.translucentFlag = translucentFlag;
            this.verticalGravity = verticalGravity;
            this.horizontalGravity = horizontalGravity;
            this.transitionName = transitionName;
            this.hideWindowFlag = hideWindowFlag;
        }
    }
}

