/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

public class AlertDialogLayout
extends LinearLayout {
    public AlertDialogLayout(Context context) {
        super(context);
    }

    public AlertDialogLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AlertDialogLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AlertDialogLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.tryOnMeasure(widthMeasureSpec, heightMeasureSpec)) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean tryOnMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightSpec;
        int heightToGive;
        View topPanel = null;
        View buttonPanel = null;
        View middlePanel = null;
        int count = this.getChildCount();
        block5: for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int id2 = child.getId();
            switch (id2) {
                case 16909085: {
                    topPanel = child;
                    continue block5;
                }
                case 16909089: {
                    buttonPanel = child;
                    continue block5;
                }
                case 16909092: 
                case 16909094: {
                    if (middlePanel != null) {
                        return false;
                    }
                    middlePanel = child;
                    continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int childState = 0;
        int usedHeight = this.getPaddingTop() + this.getPaddingBottom();
        if (topPanel != null) {
            topPanel.measure(widthMeasureSpec, 0);
            usedHeight += topPanel.getMeasuredHeight();
            childState = AlertDialogLayout.combineMeasuredStates(childState, topPanel.getMeasuredState());
        }
        int buttonHeight = 0;
        int buttonWantsHeight = 0;
        if (buttonPanel != null) {
            buttonPanel.measure(widthMeasureSpec, 0);
            buttonHeight = this.resolveMinimumHeight(buttonPanel);
            buttonWantsHeight = buttonPanel.getMeasuredHeight() - buttonHeight;
            usedHeight += buttonHeight;
            childState = AlertDialogLayout.combineMeasuredStates(childState, buttonPanel.getMeasuredState());
        }
        int middleHeight = 0;
        if (middlePanel != null) {
            int childHeightSpec2 = heightMode == 0 ? 0 : View.MeasureSpec.makeMeasureSpec(Math.max(0, heightSize - usedHeight), heightMode);
            middlePanel.measure(widthMeasureSpec, childHeightSpec2);
            middleHeight = middlePanel.getMeasuredHeight();
            usedHeight += middleHeight;
            childState = AlertDialogLayout.combineMeasuredStates(childState, middlePanel.getMeasuredState());
        }
        int remainingHeight = heightSize - usedHeight;
        if (buttonPanel != null) {
            usedHeight -= buttonHeight;
            heightToGive = Math.min(remainingHeight, buttonWantsHeight);
            if (heightToGive > 0) {
                remainingHeight -= heightToGive;
                buttonHeight += heightToGive;
            }
            childHeightSpec = View.MeasureSpec.makeMeasureSpec(buttonHeight, 0x40000000);
            buttonPanel.measure(widthMeasureSpec, childHeightSpec);
            usedHeight += buttonPanel.getMeasuredHeight();
            childState = AlertDialogLayout.combineMeasuredStates(childState, buttonPanel.getMeasuredState());
        }
        if (middlePanel != null && remainingHeight > 0) {
            usedHeight -= middleHeight;
            heightToGive = remainingHeight;
            remainingHeight -= heightToGive;
            childHeightSpec = View.MeasureSpec.makeMeasureSpec(middleHeight += heightToGive, heightMode);
            middlePanel.measure(widthMeasureSpec, childHeightSpec);
            usedHeight += middlePanel.getMeasuredHeight();
            childState = AlertDialogLayout.combineMeasuredStates(childState, middlePanel.getMeasuredState());
        }
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
        }
        int widthSizeAndState = AlertDialogLayout.resolveSizeAndState(maxWidth += this.getPaddingLeft() + this.getPaddingRight(), widthMeasureSpec, childState);
        int heightSizeAndState = AlertDialogLayout.resolveSizeAndState(usedHeight, heightMeasureSpec, 0);
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
        if (widthMode != 0x40000000) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
        return true;
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private int resolveMinimumHeight(View v) {
        ViewGroup vg;
        int minHeight = v.getMinimumHeight();
        if (minHeight > 0) {
            return minHeight;
        }
        if (v instanceof ViewGroup && (vg = (ViewGroup)v).getChildCount() == 1) {
            return this.resolveMinimumHeight(vg.getChildAt(0));
        }
        return 0;
    }
}

