/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.content.Context;
import android.view.View;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.util.ReflectionUtils;

public class RecyclerViewUtil {
    private static final String RV_PKG_PREFIX = "android.support.v7.widget.";
    public static final String CN_RECYCLER_VIEW = "android.support.v7.widget.RecyclerView";
    private static final String CN_LAYOUT_MANAGER = "android.support.v7.widget.RecyclerView$LayoutManager";
    private static final String CN_ADAPTER = "android.support.v7.widget.RecyclerView$Adapter";
    private static final String CN_LINEAR_LAYOUT_MANAGER = "android.support.v7.widget.LinearLayoutManager";
    private static final Class<?>[] LLM_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};

    public static void setAdapter(View recyclerView, BridgeContext context, LayoutlibCallback layoutlibCallback, int adapterLayout) {
        try {
            RecyclerViewUtil.setLayoutManager(recyclerView, context, layoutlibCallback);
            Object adapter = RecyclerViewUtil.createAdapter(layoutlibCallback);
            if (adapter != null) {
                RecyclerViewUtil.setProperty((Object)recyclerView, CN_ADAPTER, adapter, "setAdapter");
                RecyclerViewUtil.setProperty(adapter, Integer.TYPE, (Object)adapterLayout, "setLayoutId");
            }
        }
        catch (ReflectionUtils.ReflectionException e) {
            Throwable cause = ReflectionUtils.getCause(e);
            Bridge.getLog().error("broken", "Error occurred while trying to setup RecyclerView.", cause, null);
        }
    }

    private static void setLayoutManager(View recyclerView, BridgeContext context, LayoutlibCallback callback) throws ReflectionUtils.ReflectionException {
        Object layoutManager;
        if (RecyclerViewUtil.getLayoutManager(recyclerView) == null && (layoutManager = RecyclerViewUtil.createLayoutManager(context, callback)) != null) {
            RecyclerViewUtil.setProperty((Object)recyclerView, CN_LAYOUT_MANAGER, layoutManager, "setLayoutManager");
        }
    }

    private static Object createLayoutManager(Context context, LayoutlibCallback callback) throws ReflectionUtils.ReflectionException {
        try {
            return callback.loadView(CN_LINEAR_LAYOUT_MANAGER, (Class[])LLM_CONSTRUCTOR_SIGNATURE, new Object[]{context});
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static Object getLayoutManager(View recyclerView) throws ReflectionUtils.ReflectionException {
        return ReflectionUtils.invoke(ReflectionUtils.getMethod(recyclerView.getClass(), "getLayoutManager", new Class[0]), recyclerView, new Object[0]);
    }

    private static Object createAdapter(LayoutlibCallback layoutlibCallback) throws ReflectionUtils.ReflectionException {
        Boolean ideSupport = (Boolean)layoutlibCallback.getFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT);
        if (ideSupport != Boolean.TRUE) {
            return null;
        }
        try {
            return layoutlibCallback.loadClass(CN_ADAPTER, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static void setProperty(Object object, String propertyClassName, Object propertyValue, String propertySetter) throws ReflectionUtils.ReflectionException {
        Class<?> propertyClass = RecyclerViewUtil.getClassInstance(propertyValue, propertyClassName);
        RecyclerViewUtil.setProperty(object, propertyClass, propertyValue, propertySetter);
    }

    private static void setProperty(Object object, Class<?> propertyClass, Object propertyValue, String propertySetter) throws ReflectionUtils.ReflectionException {
        ReflectionUtils.invoke(ReflectionUtils.getMethod(object.getClass(), propertySetter, propertyClass), object, propertyValue);
    }

    private static Class<?> getClassInstance(Object object, String className) {
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!className.equals(superClass.getName())) continue;
            return superClass;
        }
        throw new RuntimeException("invalid object/classname combination.");
    }
}

