
 /**
 * <p>Contains the components necessary to create "app widgets", which users can embed in other
 * applications (such as the home screen) to quickly access application data and services without
 * launching a new activity.</p>
 *
 * <p>For more information, see the
 * <a href="{@docRoot}guide/topics/appwidgets/index.html">App Widgets</a> guide.</p>
 * {@more}
 *
 * <p>The behavior of an app widget is published by an "app widget provider."  An "app widget host" is
 * a component that can contain app widgets (such as the Home screen).</p>
 *
 * <p>Any application can publish app widgets (as an app widget provider).  All an application needs to
 * do to publish an app widget is
 * provide a {@link android.content.BroadcastReceiver} that receives the {@link
 * android.appwidget.AppWidgetManager#ACTION_APPWIDGET_UPDATE} intent
 * and provide some metadata about the app widget.  Android provides the
 * {@link android.appwidget.AppWidgetProvider} class, which extends {@link
 * android.content.BroadcastReceiver}, as a convenience class to define the app widget behavior and aid
 * in handling the broadcasts.</p>
 *
 * <p>App widget hosts are the containers in which widgets can be placed.  Most of the look and feel
 * details are left up to the widget hosts.  For example, the home screen has one way of viewing
 * widgets, but the lock screen could also contain widgets, and it would have a different way of
 * adding, removing and otherwise managing widgets.</p>
 *
 * <p>For information about implementing an app widget host, see the {@link
 * android.appwidget.AppWidgetHost} class.</p>
 @apiSince 3
 */

package android.appwidget;
