/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.midi;

import android.os.Bundle;

/**
 * This class contains information to describe a MIDI device.
 * For now we only have information that can be retrieved easily for USB devices,
 * but we will probably expand this in the future.
 *
 * This class is just an immutable object to encapsulate the MIDI device description.
 * Use the MidiDevice class to actually communicate with devices.
 * @apiSince 23
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MidiDeviceInfo implements android.os.Parcelable {

/**
 * MidiDeviceInfo should only be instantiated by MidiService implementation
 * @hide
 */

MidiDeviceInfo(int type, int id, int numInputPorts, int numOutputPorts, java.lang.String[] inputPortNames, java.lang.String[] outputPortNames, android.os.Bundle properties, boolean isPrivate) { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of the device.
 *
 * @return the device's type
 * @apiSince 23
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ID of the device.
 * This ID is generated by the MIDI service and is not persistent across device unplugs.
 *
 * @return the device's ID
 * @apiSince 23
 */

public int getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the device's number of input ports.
 *
 * @return the number of input ports
 * @apiSince 23
 */

public int getInputPortCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns the device's number of output ports.
 *
 * @return the number of output ports
 * @apiSince 23
 */

public int getOutputPortCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns information about the device's ports.
 * The ports are in unspecified order.
 *
 * @return array of {@link PortInfo}
 * @apiSince 23
 */

public android.media.midi.MidiDeviceInfo.PortInfo[] getPorts() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.os.Bundle} containing the device's properties.
 *
 * @return the device's properties
 * @apiSince 23
 */

public android.os.Bundle getProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the device is private.  Private devices are only visible and accessible
 * to clients with the same UID as the application that is hosting the device.
 *
 * @return true if the device is private
 * @apiSince 23
 */

public boolean isPrivate() { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

public void writeToParcel(android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

/** @apiSince 23 */

@androidx.annotation.RecentlyNonNull public static final android.os.Parcelable.Creator<android.media.midi.MidiDeviceInfo> CREATOR;
static { CREATOR = null; }

/**
 * Bundle key for the device's corresponding Bluetooth device.
 * The value for this property is of type {@link android.bluetooth.BluetoothDevice}.
 * Only set for Bluetooth MIDI devices.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_BLUETOOTH_DEVICE = "bluetooth_device";

/**
 * Bundle key for the device's manufacturer name property.
 * The value for this property is of type {@link java.lang.String}.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}.
 * Matches the USB device manufacturer name string for USB MIDI devices.
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_MANUFACTURER = "manufacturer";

/**
 * Bundle key for the device's user visible name property.
 * The value for this property is of type {@link java.lang.String}.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}.
 * For USB devices, this is a concatenation of the manufacturer and product names.
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_NAME = "name";

/**
 * Bundle key for the device's product name property.
 * The value for this property is of type {@link java.lang.String}.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}
 * Matches the USB device product name string for USB MIDI devices.
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_PRODUCT = "product";

/**
 * Bundle key for the device's serial number property.
 * The value for this property is of type {@link java.lang.String}.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}
 * Matches the USB device serial number for USB MIDI devices.
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_SERIAL_NUMBER = "serial_number";

/**
 * Bundle key for the device's corresponding USB device.
 * The value for this property is of type {@link android.hardware.usb.UsbDevice}.
 * Only set for USB MIDI devices.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_USB_DEVICE = "usb_device";

/**
 * Bundle key for the device's version property.
 * The value for this property is of type {@link java.lang.String}.
 * Used with the {@link android.os.Bundle} returned by {@link #getProperties}
 * Matches the USB device version number for USB MIDI devices.
 * @apiSince 23
 */

public static final java.lang.String PROPERTY_VERSION = "version";

/**
 * Constant representing Bluetooth MIDI devices for {@link #getType}
 * @apiSince 23
 */

public static final int TYPE_BLUETOOTH = 3; // 0x3

/**
 * Constant representing USB MIDI devices for {@link #getType}
 * @apiSince 23
 */

public static final int TYPE_USB = 1; // 0x1

/**
 * Constant representing virtual (software based) MIDI devices for {@link #getType}
 * @apiSince 23
 */

public static final int TYPE_VIRTUAL = 2; // 0x2
/**
 * Contains information about an input or output port.
 * @apiSince 23
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PortInfo {

PortInfo(int type, int portNumber, java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Returns the port type of the port (either {@link #TYPE_INPUT} or {@link #TYPE_OUTPUT})
 * @return the port type
 * @apiSince 23
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the port number of the port
 * @return the port number
 * @apiSince 23
 */

public int getPortNumber() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of the port, or empty string if the port has no name
 * @return the port name
 * @apiSince 23
 */

public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Port type for input ports
 * @apiSince 23
 */

public static final int TYPE_INPUT = 1; // 0x1

/**
 * Port type for output ports
 * @apiSince 23
 */

public static final int TYPE_OUTPUT = 2; // 0x2
}

}

