
 /**
 * <p>Provides classes which allow applications to use Wi-Fi Aware to discover peers and create
 *     connections to them.</p>
 * <p>Using the Wi-Fi Aware APIs, applications can advertise services, discover peers which are
 *     advertising services, and connect to them.
 *     Wi-Fi Aware is independent of Wi-Fi infrastructure (i.e. a device may or may
 *     not be associated with an AP concurrent to using Wi-Fi Aware). </p>
 * <p>The primary entry point to Wi-Fi Aware capabilities is the
 *     {@link android.net.wifi.aware.WifiAwareManager} class, which is acquired by calling
 *     {@link android.content.Context#getSystemService(String)
 *     Context.getSystemService(Context.WIFI_AWARE_SERVICE)}</p>
 *
 * <p>Some APIs may require the following user permissions:</p>
 * <ul>
 *     <li>{@link android.Manifest.permission#ACCESS_WIFI_STATE}</li>
 *     <li>{@link android.Manifest.permission#CHANGE_WIFI_STATE}</li>
 *     <li>{@link android.Manifest.permission#ACCESS_FINE_LOCATION}</li>
 * </ul>
 *
 * <p class="note"><strong>Note:</strong> Not all Android-powered devices support Wi-Fi Aware
 *     functionality.
 *     If your application only works with Wi-Fi Aware (i.e. it should only be installed on devices which
 *     support Wi-Fi Aware), declare so with a <a
 *             href="{@docRoot}guide/topics/manifest/uses-feature-element.html">
 *         {@code <uses-feature>}</a>
 *     element in the manifest file:</p>
 * <pre>
 * &lt;manifest ...>
 *     &lt;uses-feature android:name="android.hardware.wifi.aware" />
 *     ...
 * &lt;/manifest>
 * </pre>
 * <p>Alternatively, if you application does not require Wi-Fi Aware but can take advantage of it if
 *     available, you can perform
 *     the check at run-time in your code using {@link
 *     android.content.pm.PackageManager#hasSystemFeature(String)} with {@link
 *     android.content.pm.PackageManager#FEATURE_WIFI_AWARE}:</p>
 * <pre>
 *     getPackageManager().hasSystemFeature(PackageManager.FEATURE_WIFI_AWARE)
 * </pre>
 @apiSince 26
 */

package android.net.wifi.aware;
