
 /**
 * <p>Provides classes to manage Wi-Fi functionality on the device.</p>
 * <p>The Wi-Fi APIs provide a means by which applications can communicate
 * with the lower-level wireless stack that provides Wi-Fi network access. Almost all
 * information from the device supplicant is available, including the connected network's
 * link speed, IP address, negotiation state, and more, plus information about other
 * networks that are available. Some other API features include the ability to
 * scan, add, save, terminate and initiate Wi-Fi connections.</p>
 *
 * <p>Some APIs may require the following user permissions:</p>
 * <ul>
 *   <li>{@link android.Manifest.permission#ACCESS_WIFI_STATE}</li>
 *   <li>{@link android.Manifest.permission#CHANGE_WIFI_STATE}</li>
 *   <li>{@link android.Manifest.permission#CHANGE_WIFI_MULTICAST_STATE}</li>
 * </ul>
 *
 * <p class="note"><strong>Note:</strong> Not all Android-powered devices provide Wi-Fi functionality.
 * If your application uses Wi-Fi, declare so with a <a
 * href="{@docRoot}guide/topics/manifest/uses-feature-element.html">{@code <uses-feature>}</a>
 * element in the manifest file:</p>
 * <pre>
 * &lt;manifest ...>
 *     &lt;uses-feature android:name="android.hardware.wifi" />
 *     ...
 * &lt;/manifest>
 * </pre>
 @apiSince 1
 */

package android.net.wifi;
