/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.renderscript;


/**
 * The superclass for all user-defined scripts. This is only
 * intended to be used by the generated derived classes.
 * * @apiSince 11
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ScriptC extends android.renderscript.Script {

/**
 * Only intended for use by the generated derived classes.
 *
 * @param id
 * @param rs
 * @apiSince 11
 */

protected ScriptC(int id, android.renderscript.RenderScript rs) { super(0, null); throw new RuntimeException("Stub!"); }

/**
 * Only intended for use by the generated derived classes.
 *
 * @param id
 * @param rs
 *
 * @apiSince 21
 */

protected ScriptC(long id, android.renderscript.RenderScript rs) { super(0, null); throw new RuntimeException("Stub!"); }

/**
 * Only intended for use by the generated derived classes.
 *
 *
 * @param rs
 * @param resources
 * @param resourceID
 * @apiSince 11
 */

protected ScriptC(android.renderscript.RenderScript rs, android.content.res.Resources resources, int resourceID) { super(0, null); throw new RuntimeException("Stub!"); }

/**
 * Only intended for use by the generated derived classes.
 *
 * @param rs
 * @apiSince 21
 */

protected ScriptC(android.renderscript.RenderScript rs, java.lang.String resName, byte[] bitcode32, byte[] bitcode64) { super(0, null); throw new RuntimeException("Stub!"); }
}

