/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.text.style;


/**
 * The classes that affect character-level text formatting in a way that
 * changes the width or height of characters extend this class.
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class MetricAffectingSpan extends android.text.style.CharacterStyle implements android.text.style.UpdateLayout {

public MetricAffectingSpan() { throw new RuntimeException("Stub!"); }

/**
 * Classes that extend MetricAffectingSpan implement this method to update the text formatting
 * in a way that can change the width or height of characters.
 *
 * @param textPaint the paint used for drawing the text
 
 * This value must never be {@code null}.
 * @apiSince 1
 */

public abstract void updateMeasureState(@android.annotation.NonNull android.text.TextPaint textPaint);

/**
 * Returns "this" for most MetricAffectingSpans, but for
 * MetricAffectingSpans that were generated by {@link #wrap},
 * returns the underlying MetricAffectingSpan.
 * @apiSince 1
 */

public android.text.style.MetricAffectingSpan getUnderlying() { throw new RuntimeException("Stub!"); }
}

