
 /**
 * <p>Provides classes that handle tweened animations.</p>
 * <p>Android provides two mechanisms
 *     that you can use to create simple animations: <strong>tweened
 *         animation</strong>, in which you tell Android to perform a series of simple
 *     transformations (position, size, rotation, and so on) to the content of a
 *     View; and <strong>frame-by-frame animation</strong>, which loads a series of Drawable resources
 *     one after the other. Both animation types can be used in any View object
 *     to provide simple rotating timers, activity icons, and other useful UI elements.
 *     Tweened animation is handled by this package (android.view.animation); frame-by-frame animation is
 *     handled by the {@link android.graphics.drawable.AnimationDrawable} class.
 *     </p>
 *
 * <p>For more information on creating tweened or frame-by-frame animations, read the discussion in the
 * <a href="{@docRoot}guide/topics/graphics/2d-graphics.html#tween-animation">2D Graphics</a>
 * Dev Guide.</p>
 @apiSince 1
 */

package android.view.animation;
