/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget;


/**
 * <p>Defines a filterable behavior. A filterable class can have its data
 * constrained by a filter. Filterable classes are usually
 * {@link android.widget.Adapter} implementations.</p>
 *
 * @see android.widget.Filter
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Filterable {

/**
 * <p>Returns a filter that can be used to constrain data with a filtering
 * pattern.</p>
 *
 * <p>This method is usually implemented by {@link android.widget.Adapter}
 * classes.</p>
 *
 * @return a filter used to constrain data
 * @apiSince 1
 */

public android.widget.Filter getFilter();
}

