/*
 * Copyright (c) 1996, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang;


/**
 * Signals that a method has been invoked at an illegal or
 * inappropriate time.  In other words, the Java environment or
 * Java application is not in an appropriate state for the requested
 * operation.
 *
 * @author  Jonni Kanerva
 * @since   JDK1.1
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class IllegalStateException extends java.lang.RuntimeException {

/**
 * Constructs an IllegalStateException with no detail message.
 * A detail message is a String that describes this particular exception.
 * @apiSince 1
 */

public IllegalStateException() { throw new RuntimeException("Stub!"); }

/**
 * Constructs an IllegalStateException with the specified detail
 * message.  A detail message is a String that describes this particular
 * exception.
 *
 * @param s the String that contains a detailed message
 * @apiSince 1
 */

public IllegalStateException(java.lang.String s) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new exception with the specified detail message and
 * cause.
 *
 * <p>Note that the detail message associated with <code>cause</code> is
 * <i>not</i> automatically incorporated in this exception's detail
 * message.
 *
 * @param  message the detail message (which is saved for later retrieval
 *         by the {@link Throwable#getMessage()} method).
 * @param  cause the cause (which is saved for later retrieval by the
 *         {@link Throwable#getCause()} method).  (A <tt>null</tt> value
 *         is permitted, and indicates that the cause is nonexistent or
 *         unknown.)
 * @since 1.5
 * @apiSince 1
 */

public IllegalStateException(java.lang.String message, java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new exception with the specified cause and a detail
 * message of <tt>(cause==null ? null : cause.toString())</tt> (which
 * typically contains the class and detail message of <tt>cause</tt>).
 * This constructor is useful for exceptions that are little more than
 * wrappers for other throwables (for example, {@link
 * java.security.PrivilegedActionException}).
 *
 * @param  cause the cause (which is saved for later retrieval by the
 *         {@link Throwable#getCause()} method).  (A <tt>null</tt> value is
 *         permitted, and indicates that the cause is nonexistent or
 *         unknown.)
 * @since  1.5
 * @apiSince 1
 */

public IllegalStateException(java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }
}

