/*
 * Copyright (c) 2003, 2004, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang.reflect;


/**
 * {@code GenericArrayType} represents an array type whose component
 * type is either a parameterized type or a type variable.
 * @since 1.5
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface GenericArrayType extends java.lang.reflect.Type {

/**
 * Returns a {@code Type} object representing the component type
 * of this array. This method creates the component type of the
 * array.  See the declaration of {@link
 * java.lang.reflect.ParameterizedType ParameterizedType} for the
 * semantics of the creation process for parameterized types and
 * see {@link java.lang.reflect.TypeVariable TypeVariable} for the
 * creation process for type variables.
 *
 * @return  a {@code Type} object representing the component type
 *     of this array
 * @throws TypeNotPresentException if the underlying array type's
 *     component type refers to a non-existent type declaration
 * @throws MalformedParameterizedTypeException if  the
 *     underlying array type's component type refers to a
 *     parameterized type that cannot be instantiated for any reason
 * @apiSince 1
 */

@android.annotation.NonNull
public java.lang.reflect.Type getGenericComponentType();
}

