/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Notification implements android.os.Parcelable {

public Notification() { throw new RuntimeException("Stub!"); }

@Deprecated
public Notification(int icon, java.lang.CharSequence tickerText, long when) { throw new RuntimeException("Stub!"); }

public Notification(android.os.Parcel parcel) { throw new RuntimeException("Stub!"); }

public java.lang.String getGroup() { throw new RuntimeException("Stub!"); }

public java.lang.String getSortKey() { throw new RuntimeException("Stub!"); }

public android.app.Notification clone() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public java.lang.String getChannelId() { throw new RuntimeException("Stub!"); }

public long getTimeoutAfter() { throw new RuntimeException("Stub!"); }

public int getBadgeIconType() { throw new RuntimeException("Stub!"); }

public java.lang.String getShortcutId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.LocusId getLocusId() { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getSettingsText() { throw new RuntimeException("Stub!"); }

public int getGroupAlertBehavior() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.Notification.BubbleMetadata getBubbleMetadata() { throw new RuntimeException("Stub!"); }

public boolean getAllowSystemGeneratedContextualActions() { throw new RuntimeException("Stub!"); }

public android.graphics.drawable.Icon getSmallIcon() { throw new RuntimeException("Stub!"); }

public android.graphics.drawable.Icon getLargeIcon() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.util.Pair<android.app.RemoteInput,android.app.Notification.Action> findRemoteInputActionPair(boolean requiresFreeform) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.app.Notification.Action> getContextualActions() { throw new RuntimeException("Stub!"); }

public boolean hasImage() { throw new RuntimeException("Stub!"); }

public static final android.media.AudioAttributes AUDIO_ATTRIBUTES_DEFAULT;
static { AUDIO_ATTRIBUTES_DEFAULT = null; }

public static final int BADGE_ICON_LARGE = 2; // 0x2

public static final int BADGE_ICON_NONE = 0; // 0x0

public static final int BADGE_ICON_SMALL = 1; // 0x1

public static final java.lang.String CATEGORY_ALARM = "alarm";

public static final java.lang.String CATEGORY_CALL = "call";

public static final java.lang.String CATEGORY_EMAIL = "email";

public static final java.lang.String CATEGORY_ERROR = "err";

public static final java.lang.String CATEGORY_EVENT = "event";

public static final java.lang.String CATEGORY_LOCATION_SHARING = "location_sharing";

public static final java.lang.String CATEGORY_MESSAGE = "msg";

public static final java.lang.String CATEGORY_MISSED_CALL = "missed_call";

public static final java.lang.String CATEGORY_NAVIGATION = "navigation";

public static final java.lang.String CATEGORY_PROGRESS = "progress";

public static final java.lang.String CATEGORY_PROMO = "promo";

public static final java.lang.String CATEGORY_RECOMMENDATION = "recommendation";

public static final java.lang.String CATEGORY_REMINDER = "reminder";

public static final java.lang.String CATEGORY_SERVICE = "service";

public static final java.lang.String CATEGORY_SOCIAL = "social";

public static final java.lang.String CATEGORY_STATUS = "status";

public static final java.lang.String CATEGORY_STOPWATCH = "stopwatch";

public static final java.lang.String CATEGORY_SYSTEM = "sys";

public static final java.lang.String CATEGORY_TRANSPORT = "transport";

public static final java.lang.String CATEGORY_WORKOUT = "workout";

public static final int COLOR_DEFAULT = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.Notification> CREATOR;
static { CREATOR = null; }

public static final int DEFAULT_ALL = -1; // 0xffffffff

public static final int DEFAULT_LIGHTS = 4; // 0x4

public static final int DEFAULT_SOUND = 1; // 0x1

public static final int DEFAULT_VIBRATE = 2; // 0x2

public static final java.lang.String EXTRA_ANSWER_COLOR = "android.answerColor";

public static final java.lang.String EXTRA_ANSWER_INTENT = "android.answerIntent";

public static final java.lang.String EXTRA_AUDIO_CONTENTS_URI = "android.audioContents";

public static final java.lang.String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";

public static final java.lang.String EXTRA_BIG_TEXT = "android.bigText";

public static final java.lang.String EXTRA_CALL_IS_VIDEO = "android.callIsVideo";

public static final java.lang.String EXTRA_CALL_PERSON = "android.callPerson";

public static final java.lang.String EXTRA_CHANNEL_GROUP_ID = "android.intent.extra.CHANNEL_GROUP_ID";

public static final java.lang.String EXTRA_CHANNEL_ID = "android.intent.extra.CHANNEL_ID";

public static final java.lang.String EXTRA_CHRONOMETER_COUNT_DOWN = "android.chronometerCountDown";

public static final java.lang.String EXTRA_COLORIZED = "android.colorized";

public static final java.lang.String EXTRA_COMPACT_ACTIONS = "android.compactActions";

public static final java.lang.String EXTRA_CONVERSATION_TITLE = "android.conversationTitle";

public static final java.lang.String EXTRA_DECLINE_COLOR = "android.declineColor";

public static final java.lang.String EXTRA_DECLINE_INTENT = "android.declineIntent";

public static final java.lang.String EXTRA_HANG_UP_INTENT = "android.hangUpIntent";

public static final java.lang.String EXTRA_HISTORIC_MESSAGES = "android.messages.historic";

public static final java.lang.String EXTRA_INFO_TEXT = "android.infoText";

public static final java.lang.String EXTRA_IS_GROUP_CONVERSATION = "android.isGroupConversation";

@Deprecated public static final java.lang.String EXTRA_LARGE_ICON = "android.largeIcon";

public static final java.lang.String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";

public static final java.lang.String EXTRA_MEDIA_SESSION = "android.mediaSession";

public static final java.lang.String EXTRA_MESSAGES = "android.messages";

public static final java.lang.String EXTRA_MESSAGING_PERSON = "android.messagingUser";

public static final java.lang.String EXTRA_NOTIFICATION_ID = "android.intent.extra.NOTIFICATION_ID";

public static final java.lang.String EXTRA_NOTIFICATION_TAG = "android.intent.extra.NOTIFICATION_TAG";

@Deprecated public static final java.lang.String EXTRA_PEOPLE = "android.people";

public static final java.lang.String EXTRA_PEOPLE_LIST = "android.people.list";

public static final java.lang.String EXTRA_PICTURE = "android.picture";

public static final java.lang.String EXTRA_PICTURE_CONTENT_DESCRIPTION = "android.pictureContentDescription";

public static final java.lang.String EXTRA_PICTURE_ICON = "android.pictureIcon";

public static final java.lang.String EXTRA_PROGRESS = "android.progress";

public static final java.lang.String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";

public static final java.lang.String EXTRA_PROGRESS_MAX = "android.progressMax";

public static final java.lang.String EXTRA_REMOTE_INPUT_DRAFT = "android.remoteInputDraft";

public static final java.lang.String EXTRA_REMOTE_INPUT_HISTORY = "android.remoteInputHistory";

@Deprecated public static final java.lang.String EXTRA_SELF_DISPLAY_NAME = "android.selfDisplayName";

public static final java.lang.String EXTRA_SHOW_BIG_PICTURE_WHEN_COLLAPSED = "android.showBigPictureWhenCollapsed";

public static final java.lang.String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";

public static final java.lang.String EXTRA_SHOW_WHEN = "android.showWhen";

@Deprecated public static final java.lang.String EXTRA_SMALL_ICON = "android.icon";

public static final java.lang.String EXTRA_SUB_TEXT = "android.subText";

public static final java.lang.String EXTRA_SUMMARY_TEXT = "android.summaryText";

public static final java.lang.String EXTRA_TEMPLATE = "android.template";

public static final java.lang.String EXTRA_TEXT = "android.text";

public static final java.lang.String EXTRA_TEXT_LINES = "android.textLines";

public static final java.lang.String EXTRA_TITLE = "android.title";

public static final java.lang.String EXTRA_TITLE_BIG = "android.title.big";

public static final java.lang.String EXTRA_VERIFICATION_ICON = "android.verificationIcon";

public static final java.lang.String EXTRA_VERIFICATION_TEXT = "android.verificationText";

public static final int FLAG_AUTO_CANCEL = 16; // 0x10

public static final int FLAG_BUBBLE = 4096; // 0x1000

public static final int FLAG_FOREGROUND_SERVICE = 64; // 0x40

public static final int FLAG_GROUP_SUMMARY = 512; // 0x200

@Deprecated public static final int FLAG_HIGH_PRIORITY = 128; // 0x80

public static final int FLAG_INSISTENT = 4; // 0x4

public static final int FLAG_LOCAL_ONLY = 256; // 0x100

public static final int FLAG_NO_CLEAR = 32; // 0x20

public static final int FLAG_ONGOING_EVENT = 2; // 0x2

public static final int FLAG_ONLY_ALERT_ONCE = 8; // 0x8

@Deprecated public static final int FLAG_SHOW_LIGHTS = 1; // 0x1

public static final int FOREGROUND_SERVICE_DEFAULT = 0; // 0x0

public static final int FOREGROUND_SERVICE_DEFERRED = 2; // 0x2

public static final int FOREGROUND_SERVICE_IMMEDIATE = 1; // 0x1

public static final int GROUP_ALERT_ALL = 0; // 0x0

public static final int GROUP_ALERT_CHILDREN = 2; // 0x2

public static final int GROUP_ALERT_SUMMARY = 1; // 0x1

public static final java.lang.String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";

@Deprecated public static final int PRIORITY_DEFAULT = 0; // 0x0

@Deprecated public static final int PRIORITY_HIGH = 1; // 0x1

@Deprecated public static final int PRIORITY_LOW = -1; // 0xffffffff

@Deprecated public static final int PRIORITY_MAX = 2; // 0x2

@Deprecated public static final int PRIORITY_MIN = -2; // 0xfffffffe

@Deprecated public static final int STREAM_DEFAULT = -1; // 0xffffffff

public static final int VISIBILITY_PRIVATE = 0; // 0x0

public static final int VISIBILITY_PUBLIC = 1; // 0x1

public static final int VISIBILITY_SECRET = -1; // 0xffffffff

public android.app.Notification.Action[] actions;

@Deprecated public android.media.AudioAttributes audioAttributes;

@Deprecated public int audioStreamType = -1; // 0xffffffff

@Deprecated public android.widget.RemoteViews bigContentView;

public java.lang.String category;

public int color = 0; // 0x0

public android.app.PendingIntent contentIntent;

@Deprecated public android.widget.RemoteViews contentView;

@Deprecated public int defaults;

public android.app.PendingIntent deleteIntent;

public android.os.Bundle extras;

public int flags;

public android.app.PendingIntent fullScreenIntent;

@Deprecated public android.widget.RemoteViews headsUpContentView;

@Deprecated public int icon;

public int iconLevel;

@Deprecated public android.graphics.Bitmap largeIcon;

@Deprecated public int ledARGB;

@Deprecated public int ledOffMS;

@Deprecated public int ledOnMS;

public int number = 0; // 0x0

@Deprecated public int priority;

public android.app.Notification publicVersion;

@Deprecated public android.net.Uri sound;

public java.lang.CharSequence tickerText;

@Deprecated public android.widget.RemoteViews tickerView;

@Deprecated public long[] vibrate;

public int visibility;

public long when;
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Action implements android.os.Parcelable {

@Deprecated
public Action(int icon, java.lang.CharSequence title, android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

public android.graphics.drawable.Icon getIcon() { throw new RuntimeException("Stub!"); }

public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public boolean getAllowGeneratedReplies() { throw new RuntimeException("Stub!"); }

public android.app.RemoteInput[] getRemoteInputs() { throw new RuntimeException("Stub!"); }

public int getSemanticAction() { throw new RuntimeException("Stub!"); }

public boolean isContextual() { throw new RuntimeException("Stub!"); }

public android.app.RemoteInput[] getDataOnlyRemoteInputs() { throw new RuntimeException("Stub!"); }

public boolean isAuthenticationRequired() { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action clone() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.Notification.Action> CREATOR;
static { CREATOR = null; }

public static final int SEMANTIC_ACTION_ARCHIVE = 5; // 0x5

public static final int SEMANTIC_ACTION_CALL = 10; // 0xa

public static final int SEMANTIC_ACTION_DELETE = 4; // 0x4

public static final int SEMANTIC_ACTION_MARK_AS_READ = 2; // 0x2

public static final int SEMANTIC_ACTION_MARK_AS_UNREAD = 3; // 0x3

public static final int SEMANTIC_ACTION_MUTE = 6; // 0x6

public static final int SEMANTIC_ACTION_NONE = 0; // 0x0

public static final int SEMANTIC_ACTION_REPLY = 1; // 0x1

public static final int SEMANTIC_ACTION_THUMBS_DOWN = 9; // 0x9

public static final int SEMANTIC_ACTION_THUMBS_UP = 8; // 0x8

public static final int SEMANTIC_ACTION_UNMUTE = 7; // 0x7

public android.app.PendingIntent actionIntent;

@Deprecated public int icon;

public java.lang.CharSequence title;
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

@Deprecated
public Builder(int icon, java.lang.CharSequence title, android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

public Builder(android.graphics.drawable.Icon icon, java.lang.CharSequence title, android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

public Builder(android.app.Notification.Action action) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder addExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder addRemoteInput(android.app.RemoteInput remoteInput) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder setAllowGeneratedReplies(boolean allowGeneratedReplies) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder setSemanticAction(int semanticAction) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder setContextual(boolean isContextual) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder extend(android.app.Notification.Action.Extender extender) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action.Builder setAuthenticationRequired(boolean authenticationRequired) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Action build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Extender {

public android.app.Notification.Action.Builder extend(android.app.Notification.Action.Builder builder);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class WearableExtender implements android.app.Notification.Action.Extender {

public WearableExtender() { throw new RuntimeException("Stub!"); }

public WearableExtender(android.app.Notification.Action action) { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action.Builder extend(android.app.Notification.Action.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action.WearableExtender clone() { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action.WearableExtender setAvailableOffline(boolean availableOffline) { throw new RuntimeException("Stub!"); }

public boolean isAvailableOffline() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Action.WearableExtender setInProgressLabel(java.lang.CharSequence label) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.CharSequence getInProgressLabel() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Action.WearableExtender setConfirmLabel(java.lang.CharSequence label) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.CharSequence getConfirmLabel() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Action.WearableExtender setCancelLabel(java.lang.CharSequence label) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.CharSequence getCancelLabel() { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action.WearableExtender setHintLaunchesActivity(boolean hintLaunchesActivity) { throw new RuntimeException("Stub!"); }

public boolean getHintLaunchesActivity() { throw new RuntimeException("Stub!"); }

public android.app.Notification.Action.WearableExtender setHintDisplayActionInline(boolean hintDisplayInline) { throw new RuntimeException("Stub!"); }

public boolean getHintDisplayActionInline() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class BigPictureStyle extends android.app.Notification.Style {

public BigPictureStyle() { throw new RuntimeException("Stub!"); }

@Deprecated
public BigPictureStyle(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle setBigContentTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle setSummaryText(@android.annotation.Nullable java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle setContentDescription(@android.annotation.Nullable java.lang.CharSequence contentDescription) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle bigPicture(@android.annotation.Nullable android.graphics.Bitmap b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle bigPicture(@android.annotation.Nullable android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle showBigPictureWhenCollapsed(boolean show) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle bigLargeIcon(@android.annotation.Nullable android.graphics.Bitmap b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BigPictureStyle bigLargeIcon(@android.annotation.Nullable android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class BigTextStyle extends android.app.Notification.Style {

public BigTextStyle() { throw new RuntimeException("Stub!"); }

@Deprecated
public BigTextStyle(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.BigTextStyle setBigContentTitle(java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

public android.app.Notification.BigTextStyle setSummaryText(java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }

public android.app.Notification.BigTextStyle bigText(java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BubbleMetadata implements android.os.Parcelable {

private BubbleMetadata() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getShortcutId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.PendingIntent getIntent() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.PendingIntent getDeleteIntent() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.drawable.Icon getIcon() { throw new RuntimeException("Stub!"); }

public int getDesiredHeight() { throw new RuntimeException("Stub!"); }

public int getDesiredHeightResId() { throw new RuntimeException("Stub!"); }

public boolean getAutoExpandBubble() { throw new RuntimeException("Stub!"); }

public boolean isNotificationSuppressed() { throw new RuntimeException("Stub!"); }

public boolean isBubbleSuppressable() { throw new RuntimeException("Stub!"); }

public boolean isBubbleSuppressed() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.Notification.BubbleMetadata> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

@Deprecated
public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull java.lang.String shortcutId) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.app.PendingIntent intent, @android.annotation.NonNull android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setIntent(@android.annotation.NonNull android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setIcon(@android.annotation.NonNull android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setDesiredHeight(int height) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setDesiredHeightResId(int heightResId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setAutoExpandBubble(boolean shouldExpand) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setSuppressNotification(boolean shouldSuppressNotif) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setSuppressableBubble(boolean suppressBubble) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata.Builder setDeleteIntent(@android.annotation.Nullable android.app.PendingIntent deleteIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.BubbleMetadata build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder(android.content.Context context, java.lang.String channelId) { throw new RuntimeException("Stub!"); }

@Deprecated
public Builder(android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setShortcutId(java.lang.String shortcutId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setLocusId(@android.annotation.Nullable android.content.LocusId locusId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setBadgeIconType(int icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setGroupAlertBehavior(int groupAlertBehavior) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setBubbleMetadata(@android.annotation.Nullable android.app.Notification.BubbleMetadata data) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setChannelId(java.lang.String channelId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setTimeoutAfter(long durationMs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setWhen(long when) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setShowWhen(boolean show) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setUsesChronometer(boolean b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setChronometerCountDown(boolean countDown) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSmallIcon(int icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSmallIcon(int icon, int level) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSmallIcon(android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setContentTitle(java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setContentText(java.lang.CharSequence text) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSubText(java.lang.CharSequence text) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSettingsText(java.lang.CharSequence text) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setRemoteInputHistory(java.lang.CharSequence[] text) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setNumber(int number) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setContentInfo(java.lang.CharSequence info) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setProgress(int max, int progress, boolean indeterminate) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setContent(android.widget.RemoteViews views) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setCustomContentView(android.widget.RemoteViews contentView) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setCustomBigContentView(android.widget.RemoteViews contentView) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setCustomHeadsUpContentView(android.widget.RemoteViews contentView) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setContentIntent(android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setDeleteIntent(android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setFullScreenIntent(android.app.PendingIntent intent, boolean highPriority) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setTicker(java.lang.CharSequence tickerText) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setTicker(java.lang.CharSequence tickerText, android.widget.RemoteViews views) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setLargeIcon(android.graphics.Bitmap b) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setLargeIcon(android.graphics.drawable.Icon icon) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setSound(android.net.Uri sound) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setSound(android.net.Uri sound, int streamType) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setSound(android.net.Uri sound, android.media.AudioAttributes audioAttributes) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setVibrate(long[] pattern) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setLights(int argb, int onMs, int offMs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setOngoing(boolean ongoing) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setColorized(boolean colorize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setOnlyAlertOnce(boolean onlyAlertOnce) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setForegroundServiceBehavior(int behavior) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setAutoCancel(boolean autoCancel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setLocalOnly(boolean localOnly) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setDefaults(int defaults) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder setPriority(int pri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setCategory(java.lang.String category) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder addPerson(java.lang.String uri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder addPerson(android.app.Person person) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setGroup(java.lang.String groupKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setGroupSummary(boolean isGroupSummary) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setSortKey(java.lang.String sortKey) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder addExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.Builder addAction(int icon, java.lang.CharSequence title, android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder addAction(android.app.Notification.Action action) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setActions(android.app.Notification.Action... actions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setStyle(android.app.Notification.Style style) { throw new RuntimeException("Stub!"); }

public android.app.Notification.Style getStyle() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setVisibility(int visibility) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setPublicVersion(android.app.Notification n) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder extend(android.app.Notification.Extender extender) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setFlag(int mask, boolean value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setColor(int argb) { throw new RuntimeException("Stub!"); }

public android.widget.RemoteViews createContentView() { throw new RuntimeException("Stub!"); }

public android.widget.RemoteViews createBigContentView() { throw new RuntimeException("Stub!"); }

public android.widget.RemoteViews createHeadsUpContentView() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.Notification.Builder recoverBuilder(android.content.Context context, android.app.Notification n) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.Builder setAllowSystemGeneratedContextualActions(boolean allowed) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification getNotification() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class CallStyle extends android.app.Notification.Style {

CallStyle() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.Notification.CallStyle forIncomingCall(@android.annotation.NonNull android.app.Person person, @android.annotation.NonNull android.app.PendingIntent declineIntent, @android.annotation.NonNull android.app.PendingIntent answerIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.Notification.CallStyle forOngoingCall(@android.annotation.NonNull android.app.Person person, @android.annotation.NonNull android.app.PendingIntent hangUpIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.app.Notification.CallStyle forScreeningCall(@android.annotation.NonNull android.app.Person person, @android.annotation.NonNull android.app.PendingIntent hangUpIntent, @android.annotation.NonNull android.app.PendingIntent answerIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.CallStyle setIsVideo(boolean isVideo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.CallStyle setVerificationIcon(@android.annotation.Nullable android.graphics.drawable.Icon verificationIcon) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.CallStyle setVerificationText(@android.annotation.Nullable java.lang.CharSequence verificationText) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.CallStyle setAnswerButtonColorHint(int color) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Notification.CallStyle setDeclineButtonColorHint(int color) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CarExtender implements android.app.Notification.Extender {

public CarExtender() { throw new RuntimeException("Stub!"); }

public CarExtender(android.app.Notification notif) { throw new RuntimeException("Stub!"); }

public android.app.Notification.Builder extend(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender setColor(int color) { throw new RuntimeException("Stub!"); }

public int getColor() { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender setLargeIcon(android.graphics.Bitmap largeIcon) { throw new RuntimeException("Stub!"); }

public android.graphics.Bitmap getLargeIcon() { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender setUnreadConversation(android.app.Notification.CarExtender.UnreadConversation unreadConversation) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.UnreadConversation getUnreadConversation() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder(java.lang.String name) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.Builder addMessage(java.lang.String message) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.Builder setReplyAction(android.app.PendingIntent pendingIntent, android.app.RemoteInput remoteInput) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.Builder setReadPendingIntent(android.app.PendingIntent pendingIntent) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.Builder setLatestTimestamp(long timestamp) { throw new RuntimeException("Stub!"); }

public android.app.Notification.CarExtender.UnreadConversation build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class UnreadConversation {

UnreadConversation() { throw new RuntimeException("Stub!"); }

public java.lang.String[] getMessages() { throw new RuntimeException("Stub!"); }

public android.app.RemoteInput getRemoteInput() { throw new RuntimeException("Stub!"); }

public android.app.PendingIntent getReplyPendingIntent() { throw new RuntimeException("Stub!"); }

public android.app.PendingIntent getReadPendingIntent() { throw new RuntimeException("Stub!"); }

public java.lang.String[] getParticipants() { throw new RuntimeException("Stub!"); }

public java.lang.String getParticipant() { throw new RuntimeException("Stub!"); }

public long getLatestTimestamp() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class DecoratedCustomViewStyle extends android.app.Notification.Style {

public DecoratedCustomViewStyle() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class DecoratedMediaCustomViewStyle extends android.app.Notification.MediaStyle {

public DecoratedMediaCustomViewStyle() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Extender {

public android.app.Notification.Builder extend(android.app.Notification.Builder builder);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InboxStyle extends android.app.Notification.Style {

public InboxStyle() { throw new RuntimeException("Stub!"); }

@Deprecated
public InboxStyle(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.InboxStyle setBigContentTitle(java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

public android.app.Notification.InboxStyle setSummaryText(java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }

public android.app.Notification.InboxStyle addLine(java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class MediaStyle extends android.app.Notification.Style {

public MediaStyle() { throw new RuntimeException("Stub!"); }

@Deprecated
public MediaStyle(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MediaStyle setShowActionsInCompactView(int... actions) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MediaStyle setMediaSession(android.media.session.MediaSession.Token token) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class MessagingStyle extends android.app.Notification.Style {

@Deprecated
public MessagingStyle(@android.annotation.NonNull java.lang.CharSequence userDisplayName) { throw new RuntimeException("Stub!"); }

public MessagingStyle(@android.annotation.NonNull android.app.Person user) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.Person getUser() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.CharSequence getUserDisplayName() { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle setConversationTitle(@android.annotation.Nullable java.lang.CharSequence conversationTitle) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getConversationTitle() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.MessagingStyle addMessage(java.lang.CharSequence text, long timestamp, java.lang.CharSequence sender) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle addMessage(@android.annotation.NonNull java.lang.CharSequence text, long timestamp, @android.annotation.Nullable android.app.Person sender) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle addMessage(android.app.Notification.MessagingStyle.Message message) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle addHistoricMessage(android.app.Notification.MessagingStyle.Message message) { throw new RuntimeException("Stub!"); }

public java.util.List<android.app.Notification.MessagingStyle.Message> getMessages() { throw new RuntimeException("Stub!"); }

public java.util.List<android.app.Notification.MessagingStyle.Message> getHistoricMessages() { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle setGroupConversation(boolean isGroupConversation) { throw new RuntimeException("Stub!"); }

public boolean isGroupConversation() { throw new RuntimeException("Stub!"); }

public static final int MAXIMUM_RETAINED_MESSAGES = 25; // 0x19
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Message {

@Deprecated
public Message(java.lang.CharSequence text, long timestamp, java.lang.CharSequence sender) { throw new RuntimeException("Stub!"); }

public Message(@android.annotation.NonNull java.lang.CharSequence text, long timestamp, @android.annotation.Nullable android.app.Person sender) { throw new RuntimeException("Stub!"); }

public android.app.Notification.MessagingStyle.Message setData(java.lang.String dataMimeType, android.net.Uri dataUri) { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getText() { throw new RuntimeException("Stub!"); }

public long getTimestamp() { throw new RuntimeException("Stub!"); }

public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.CharSequence getSender() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.Person getSenderPerson() { throw new RuntimeException("Stub!"); }

public java.lang.String getDataMimeType() { throw new RuntimeException("Stub!"); }

public android.net.Uri getDataUri() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.List<android.app.Notification.MessagingStyle.Message> getMessagesFromBundleArray(@android.annotation.Nullable android.os.Parcelable[] bundles) { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Style {

public Style() { throw new RuntimeException("Stub!"); }

protected void internalSetBigContentTitle(java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

protected void internalSetSummaryText(java.lang.CharSequence cs) { throw new RuntimeException("Stub!"); }

public void setBuilder(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

protected void checkBuilder() { throw new RuntimeException("Stub!"); }

protected android.widget.RemoteViews getStandardView(int layoutId) { throw new RuntimeException("Stub!"); }

public android.app.Notification build() { throw new RuntimeException("Stub!"); }

protected android.app.Notification.Builder mBuilder;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class WearableExtender implements android.app.Notification.Extender {

public WearableExtender() { throw new RuntimeException("Stub!"); }

public WearableExtender(android.app.Notification notif) { throw new RuntimeException("Stub!"); }

public android.app.Notification.Builder extend(android.app.Notification.Builder builder) { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender clone() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender addAction(android.app.Notification.Action action) { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender addActions(java.util.List<android.app.Notification.Action> actions) { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender clearActions() { throw new RuntimeException("Stub!"); }

public java.util.List<android.app.Notification.Action> getActions() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setDisplayIntent(android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.PendingIntent getDisplayIntent() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender addPage(android.app.Notification page) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender addPages(java.util.List<android.app.Notification> pages) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender clearPages() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.util.List<android.app.Notification> getPages() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setBackground(android.graphics.Bitmap background) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.graphics.Bitmap getBackground() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setContentIcon(int icon) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getContentIcon() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setContentIconGravity(int contentIconGravity) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getContentIconGravity() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setContentAction(int actionIndex) { throw new RuntimeException("Stub!"); }

public int getContentAction() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setGravity(int gravity) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getGravity() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setCustomSizePreset(int sizePreset) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getCustomSizePreset() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setCustomContentHeight(int height) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getCustomContentHeight() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setStartScrollBottom(boolean startScrollBottom) { throw new RuntimeException("Stub!"); }

public boolean getStartScrollBottom() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setContentIntentAvailableOffline(boolean contentIntentAvailableOffline) { throw new RuntimeException("Stub!"); }

public boolean getContentIntentAvailableOffline() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setHintHideIcon(boolean hintHideIcon) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getHintHideIcon() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setHintShowBackgroundOnly(boolean hintShowBackgroundOnly) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getHintShowBackgroundOnly() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setHintAvoidBackgroundClipping(boolean hintAvoidBackgroundClipping) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getHintAvoidBackgroundClipping() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setHintScreenTimeout(int timeout) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getHintScreenTimeout() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.app.Notification.WearableExtender setHintAmbientBigPicture(boolean hintAmbientBigPicture) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getHintAmbientBigPicture() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setHintContentIntentLaunchesActivity(boolean hintContentIntentLaunchesActivity) { throw new RuntimeException("Stub!"); }

public boolean getHintContentIntentLaunchesActivity() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setDismissalId(java.lang.String dismissalId) { throw new RuntimeException("Stub!"); }

public java.lang.String getDismissalId() { throw new RuntimeException("Stub!"); }

public android.app.Notification.WearableExtender setBridgeTag(java.lang.String bridgeTag) { throw new RuntimeException("Stub!"); }

public java.lang.String getBridgeTag() { throw new RuntimeException("Stub!"); }

@Deprecated public static final int SCREEN_TIMEOUT_LONG = -1; // 0xffffffff

@Deprecated public static final int SCREEN_TIMEOUT_SHORT = 0; // 0x0

@Deprecated public static final int SIZE_DEFAULT = 0; // 0x0

@Deprecated public static final int SIZE_FULL_SCREEN = 5; // 0x5

@Deprecated public static final int SIZE_LARGE = 4; // 0x4

@Deprecated public static final int SIZE_MEDIUM = 3; // 0x3

@Deprecated public static final int SIZE_SMALL = 2; // 0x2

@Deprecated public static final int SIZE_XSMALL = 1; // 0x1

public static final int UNSET_ACTION_INDEX = -1; // 0xffffffff
}

}

