/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * The AppSearch Schema for a particular type of document.
 *
 * <p>For example, an e-mail message or a music recording could be a schema type.
 *
 * <p>The schema consists of type information, properties, and config (like tokenization type).
 *
 * @see android.app.appsearch.AppSearchSession#setSchema
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchSchema {

AppSearchSchema() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Returns the name of this schema type, e.g. Email. */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.app.appsearch.AppSearchSchema.PropertyConfig PropertyConfig}s that are part of this schema.
 *
 * <p>This method creates a new list when called.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.AppSearchSchema.PropertyConfig> getProperties() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Configuration for a property containing a boolean. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BooleanPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

BooleanPropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig BooleanPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig.Builder BooleanPropertyConfig.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BooleanPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.BooleanPropertyConfig BooleanPropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BooleanPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Builder for {@link android.app.appsearch.AppSearchSchema objects}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.Builder AppSearchSchema.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/** Adds a property to the given type. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.Builder addProperty(@android.annotation.NonNull android.app.appsearch.AppSearchSchema.PropertyConfig propertyConfig) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema AppSearchSchema} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema build() { throw new RuntimeException("Stub!"); }
}

/** Configuration for a property containing a byte array. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BytesPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

BytesPropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig BytesPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig.Builder BytesPropertyConfig.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BytesPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.BytesPropertyConfig BytesPropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.BytesPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing another Document. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DocumentPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

DocumentPropertyConfig() { throw new RuntimeException("Stub!"); }

/** Returns the logical schema-type of the contents of this document property. */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether fields in the nested document should be indexed according to that
 * document's schema.
 *
 * <p>If false, the nested document's properties are not indexed regardless of its own
 * schema.
 */

public boolean shouldIndexNestedProperties() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.DocumentPropertyConfig DocumentPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new {@link android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder DocumentPropertyConfig.Builder}.
 *
 * @param propertyName The logical name of the property in the schema, which will be
 *     used as the key for this property in {@link android.app.appsearch.GenericDocument.Builder#setPropertyDocument      }.
 * @param schemaType The type of documents which will be stored in this property.
 *     Documents of different types cannot be mixed into a single property.
 */

public Builder(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Configures whether fields in the nested document should be indexed according to that
 * document's schema.
 *
 * <p>If false, the nested document's properties are not indexed regardless of its own
 * schema.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig.Builder setShouldIndexNestedProperties(boolean indexNestedProperties) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.PropertyConfig PropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DocumentPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing a double-precision decimal number. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DoublePropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

DoublePropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig DoublePropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig.Builder DoublePropertyConfig.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DoublePropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.DoublePropertyConfig DoublePropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.DoublePropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/** Configuration for a property containing a 64-bit integer. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class LongPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

LongPropertyConfig() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig LongPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig.Builder LongPropertyConfig.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.LongPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig LongPropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.LongPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

/**
 * Common configuration for a single property (field) in a Document.
 *
 * <p>For example, an {@code EmailMessage} would be a type and the {@code subject} would be a
 * property.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class PropertyConfig {

PropertyConfig() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Returns the name of this property. */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the cardinality of the property (whether it is optional, required or repeated).
 */

public int getCardinality() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Zero or one value [0,1]. */

public static final int CARDINALITY_OPTIONAL = 2; // 0x2

/** Any number of items (including zero) [0...*]. */

public static final int CARDINALITY_REPEATED = 1; // 0x1

/** Exactly one value [1]. */

public static final int CARDINALITY_REQUIRED = 3; // 0x3
}

/** Configuration for a property of type String in a Document. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StringPropertyConfig extends android.app.appsearch.AppSearchSchema.PropertyConfig {

StringPropertyConfig() { throw new RuntimeException("Stub!"); }

/** Returns how the property is indexed. */

public int getIndexingType() { throw new RuntimeException("Stub!"); }

/** Returns how this property is tokenized (split into words). */

public int getTokenizerType() { throw new RuntimeException("Stub!"); }

/**
 * Content in this property should only be returned for queries matching the exact tokens
 * appearing in this property.
 *
 * <p>Ex. A property with "fool" should NOT match a query for "foo".
 */

public static final int INDEXING_TYPE_EXACT_TERMS = 1; // 0x1

/** Content in this property will not be tokenized or indexed. */

public static final int INDEXING_TYPE_NONE = 0; // 0x0

/**
 * Content in this property should be returned for queries that are either exact matches or
 * query matches of the tokens appearing in this property.
 *
 * <p>Ex. A property with "fool" <b>should</b> match a query for "foo".
 */

public static final int INDEXING_TYPE_PREFIXES = 2; // 0x2

/**
 * This value indicates that no tokens should be extracted from this property.
 *
 * <p>It is only valid for tokenizer_type to be 'NONE' if {@link #getIndexingType} is {@link
 * #INDEXING_TYPE_NONE}.
 */

public static final int TOKENIZER_TYPE_NONE = 0; // 0x0

/**
 * Tokenization for plain text. This value indicates that tokens should be extracted from
 * this property based on word breaks. Segments of whitespace and punctuation are not
 * considered tokens.
 *
 * <p>Ex. A property with "foo bar. baz." will produce tokens for "foo", "bar" and "baz".
 * The segments " " and "." will not be considered tokens.
 *
 * <p>It is only valid for tokenizer_type to be 'PLAIN' if {@link #getIndexingType} is
 * {@link #INDEXING_TYPE_EXACT_TERMS} or {@link #INDEXING_TYPE_PREFIXES}.
 */

public static final int TOKENIZER_TYPE_PLAIN = 1; // 0x1
/** Builder for {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig StringPropertyConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a new {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder StringPropertyConfig.Builder}. */

public Builder(@android.annotation.NonNull java.lang.String propertyName) { throw new RuntimeException("Stub!"); }

/**
 * The cardinality of the property (whether it is optional, required or repeated).
 *
 * <p>If this method is not called, the default cardinality is {@link android.app.appsearch.AppSearchSchema.PropertyConfig#CARDINALITY_OPTIONAL  }.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setCardinality(int cardinality) { throw new RuntimeException("Stub!"); }

/**
 * Configures how a property should be indexed so that it can be retrieved by queries.
 *
 * <p>If this method is not called, the default indexing type is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE  }, so that it cannot be matched by queries.
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setIndexingType(int indexingType) { throw new RuntimeException("Stub!"); }

/**
 * Configures how this property should be tokenized (split into words).
 *
 * <p>If this method is not called, the default indexing type is {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE  }, so that it is not tokenized.
 *
 * <p>This method must be called with a value other than {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_NONE  } if the property is indexed (i.e. if {@link
 * #setIndexingType} has been called with a value other than {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE  }).
 */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig.Builder setTokenizerType(int tokenizerType) { throw new RuntimeException("Stub!"); }

/** Constructs a new {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig StringPropertyConfig} from the contents of this builder. */

@android.annotation.NonNull
public android.app.appsearch.AppSearchSchema.StringPropertyConfig build() { throw new RuntimeException("Stub!"); }
}

}

}

