/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/** The response class of {@link android.app.appsearch.AppSearchSession#getSchema AppSearchSession#getSchema} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetSchemaResponse {

GetSchemaResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns the overall database schema version.
 *
 * <p>If the database is empty, 0 will be returned.
 */

public int getVersion() { throw new RuntimeException("Stub!"); }

/**
 * Return the schemas most recently successfully provided to {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema}.
 *
 * <p>It is inefficient to call this method repeatedly.
 */

@android.annotation.NonNull
public java.util.Set<android.app.appsearch.AppSearchSchema> getSchemas() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the database overall schema version.
 *
 * <p>Default version is 0
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setVersion(int version) { throw new RuntimeException("Stub!"); }

/** Adds one {@link android.app.appsearch.AppSearchSchema AppSearchSchema} to the schema list. */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder addSchema(@android.annotation.NonNull android.app.appsearch.AppSearchSchema schema) { throw new RuntimeException("Stub!"); }

/** Builds a {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} object. */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse build() { throw new RuntimeException("Stub!"); }
}

}

