/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch.exceptions;

import android.app.appsearch.AppSearchResult;

/**
 * An exception thrown by {@link android.app.appsearch.AppSearchSession} or a subcomponent.
 *
 * <p>These exceptions can be converted into a failed {@link android.app.appsearch.AppSearchResult AppSearchResult} for propagating to the
 * client.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AppSearchException extends java.lang.Exception {

/**
 * Initializes an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException} with no message.
 *
 * @param resultCode One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode AppSearchResult#getResultCode}.
 */

public AppSearchException(int resultCode) { throw new RuntimeException("Stub!"); }

/**
 * Initializes an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException} with a result code and message.
 *
 * @param resultCode One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode AppSearchResult#getResultCode}.
 * @param message The detail message (which is saved for later retrieval by the {@link
 *     #getMessage()} method).
 */

public AppSearchException(int resultCode, @android.annotation.Nullable java.lang.String message) { throw new RuntimeException("Stub!"); }

/**
 * Initializes an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException} with a result code, message and cause.
 *
 * @param resultCode One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode AppSearchResult#getResultCode}.
 * @param message The detail message (which is saved for later retrieval by the {@link
 *     #getMessage()} method).
 * @param cause The cause (which is saved for later retrieval by the {@link #getCause()}
 *     method). (A null value is permitted, and indicates that the cause is nonexistent or
 *     unknown.)
 */

public AppSearchException(int resultCode, @android.annotation.Nullable java.lang.String message, @android.annotation.Nullable java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Returns the result code this exception was constructed with.
 *
 * @return One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode AppSearchResult#getResultCode}.
 */

public int getResultCode() { throw new RuntimeException("Stub!"); }

/** Converts this {@link java.lang.Exception} into a failed {@link android.app.appsearch.AppSearchResult AppSearchResult}. */

@android.annotation.NonNull
public <T> android.app.appsearch.AppSearchResult<T> toAppSearchResult() { throw new RuntimeException("Stub!"); }
}

