/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;

import android.net.Network;

/**
 * IkeSessionConnectionInfo represents the connection information of an {@link android.net.ipsec.ike.IkeSession IkeSession}.
 *
 * <p>Connection information includes IP addresses of both the IKE client and server and the network
 * being used.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeSessionConnectionInfo {

/**
 * Construct an instance of {@link android.net.ipsec.ike.IkeSessionConnectionInfo IkeSessionConnectionInfo}.
 *
 * <p>Except for testing, IKE library users normally do not instantiate {@link android.net.ipsec.ike.IkeSessionConnectionInfo IkeSessionConnectionInfo} themselves but instead get a reference via {@link android.net.ipsec.ike.IkeSessionConfiguration IkeSessionConfiguration} or {@link android.net.ipsec.ike.IkeSessionCallback IkeSessionCallback}
 */

public IkeSessionConnectionInfo(@android.annotation.NonNull java.net.InetAddress localAddress, @android.annotation.NonNull java.net.InetAddress remoteAddress, @android.annotation.NonNull android.net.Network network) { throw new RuntimeException("Stub!"); }

/**
 * Returns the local IP address for the underlying {@link android.net.Network Network} being used.
 *
 * @return the local IP address.
 */

@android.annotation.NonNull
public java.net.InetAddress getLocalAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the remote IP address for the underlying {@link android.net.Network Network} being used.
 *
 * @return the remote IP address.
 */

@android.annotation.NonNull
public java.net.InetAddress getRemoteAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the underlying {@link android.net.Network Network} being used.
 *
 * @return the underlying {@link android.net.Network Network} that carries all IKE traffic.
 */

@android.annotation.NonNull
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }
}

