/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.security.identity;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IdentityCredential {

IdentityCredential() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.security.KeyPair createEphemeralKeyPair();

public abstract void setReaderEphemeralPublicKey(@android.annotation.NonNull java.security.PublicKey readerEphemeralPublicKey) throws java.security.InvalidKeyException;

@android.annotation.NonNull
public abstract byte[] encryptMessageToReader(@android.annotation.NonNull byte[] messagePlaintext);

@android.annotation.NonNull
public abstract byte[] decryptMessageFromReader(@android.annotation.NonNull byte[] messageCiphertext) throws android.security.identity.MessageDecryptionException;

@android.annotation.NonNull
public abstract java.util.Collection<java.security.cert.X509Certificate> getCredentialKeyCertificateChain();

public abstract void setAllowUsingExhaustedKeys(boolean allowUsingExhaustedKeys);

public void setAllowUsingExpiredKeys(boolean allowUsingExpiredKeys) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.security.identity.ResultData getEntries(@android.annotation.Nullable byte[] requestMessage, @android.annotation.NonNull java.util.Map<java.lang.String,java.util.Collection<java.lang.String>> entriesToRequest, @android.annotation.Nullable byte[] sessionTranscript, @android.annotation.Nullable byte[] readerSignature) throws android.security.identity.EphemeralPublicKeyNotFoundException, android.security.identity.InvalidReaderSignatureException, android.security.identity.InvalidRequestMessageException, android.security.identity.NoAuthenticationKeyAvailableException, android.security.identity.SessionTranscriptMismatchException;

public abstract void setAvailableAuthenticationKeys(int keyCount, int maxUsesPerKey);

@android.annotation.NonNull
public abstract java.util.Collection<java.security.cert.X509Certificate> getAuthKeysNeedingCertification();

@Deprecated
public abstract void storeStaticAuthenticationData(@android.annotation.NonNull java.security.cert.X509Certificate authenticationKey, @android.annotation.NonNull byte[] staticAuthData) throws android.security.identity.UnknownAuthenticationKeyException;

public void storeStaticAuthenticationData(@android.annotation.NonNull java.security.cert.X509Certificate authenticationKey, @android.annotation.NonNull java.time.Instant expirationDate, @android.annotation.NonNull byte[] staticAuthData) throws android.security.identity.UnknownAuthenticationKeyException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract int[] getAuthenticationDataUsageCount();

@android.annotation.NonNull
public byte[] proveOwnership(@android.annotation.NonNull byte[] challenge) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] delete(@android.annotation.NonNull byte[] challenge) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] update(@android.annotation.NonNull android.security.identity.PersonalizationData personalizationData) { throw new RuntimeException("Stub!"); }
}

