/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.security.identity;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IdentityCredentialStore {

IdentityCredentialStore() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.security.identity.IdentityCredentialStore getInstance(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.security.identity.IdentityCredentialStore getDirectAccessInstance(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.lang.String[] getSupportedDocTypes();

@android.annotation.NonNull
public abstract android.security.identity.WritableIdentityCredential createCredential(@android.annotation.NonNull java.lang.String credentialName, @android.annotation.NonNull java.lang.String docType) throws android.security.identity.AlreadyPersonalizedException, android.security.identity.DocTypeNotSupportedException;

@android.annotation.Nullable
public abstract android.security.identity.IdentityCredential getCredentialByName(@android.annotation.NonNull java.lang.String credentialName, int cipherSuite) throws android.security.identity.CipherSuiteNotSupportedException;

@Deprecated
@android.annotation.Nullable
public abstract byte[] deleteCredentialByName(@android.annotation.NonNull java.lang.String credentialName);

public static final int CIPHERSUITE_ECDHE_HKDF_ECDSA_WITH_AES_256_GCM_SHA256 = 1; // 0x1
}

