/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DisconnectCause {

private DisconnectCause() { throw new RuntimeException("Stub!"); }

public static final int ALREADY_DIALING = 72; // 0x48

public static final int ANSWERED_ELSEWHERE = 52; // 0x34

public static final int BUSY = 4; // 0x4

public static final int CALLING_DISABLED = 74; // 0x4a

public static final int CALL_BARRED = 20; // 0x14

public static final int CALL_PULLED = 51; // 0x33

public static final int CANT_CALL_WHILE_RINGING = 73; // 0x49

public static final int CDMA_ACCESS_BLOCKED = 35; // 0x23

public static final int CDMA_ACCESS_FAILURE = 32; // 0x20

public static final int CDMA_ALREADY_ACTIVATED = 49; // 0x31

public static final int CDMA_DROP = 27; // 0x1b

public static final int CDMA_INTERCEPT = 28; // 0x1c

public static final int CDMA_LOCKED_UNTIL_POWER_CYCLE = 26; // 0x1a

public static final int CDMA_NOT_EMERGENCY = 34; // 0x22

public static final int CDMA_PREEMPTED = 33; // 0x21

public static final int CDMA_REORDER = 29; // 0x1d

public static final int CDMA_RETRY_ORDER = 31; // 0x1f

public static final int CDMA_SO_REJECT = 30; // 0x1e

public static final int CONGESTION = 5; // 0x5

public static final int CS_RESTRICTED = 22; // 0x16

public static final int CS_RESTRICTED_EMERGENCY = 24; // 0x18

public static final int CS_RESTRICTED_NORMAL = 23; // 0x17

public static final int DATA_DISABLED = 54; // 0x36

public static final int DATA_LIMIT_REACHED = 55; // 0x37

public static final int DIALED_CALL_FORWARDING_WHILE_ROAMING = 57; // 0x39

public static final int DIALED_MMI = 39; // 0x27

public static final int DIAL_LOW_BATTERY = 62; // 0x3e

public static final int DIAL_MODIFIED_TO_DIAL = 48; // 0x30

public static final int DIAL_MODIFIED_TO_DIAL_VIDEO = 66; // 0x42

public static final int DIAL_MODIFIED_TO_SS = 47; // 0x2f

public static final int DIAL_MODIFIED_TO_USSD = 46; // 0x2e

public static final int DIAL_VIDEO_MODIFIED_TO_DIAL = 69; // 0x45

public static final int DIAL_VIDEO_MODIFIED_TO_DIAL_VIDEO = 70; // 0x46

public static final int DIAL_VIDEO_MODIFIED_TO_SS = 67; // 0x43

public static final int DIAL_VIDEO_MODIFIED_TO_USSD = 68; // 0x44

public static final int EMERGENCY_CALL_OVER_WFC_NOT_AVAILABLE = 78; // 0x4e

public static final int EMERGENCY_PERM_FAILURE = 64; // 0x40

public static final int EMERGENCY_TEMP_FAILURE = 63; // 0x3f

public static final int ERROR_UNSPECIFIED = 36; // 0x24

public static final int FDN_BLOCKED = 21; // 0x15

public static final int ICC_ERROR = 19; // 0x13

public static final int IMEI_NOT_ACCEPTED = 58; // 0x3a

public static final int IMS_ACCESS_BLOCKED = 60; // 0x3c

public static final int IMS_MERGED_SUCCESSFULLY = 45; // 0x2d

public static final int IMS_SIP_ALTERNATE_EMERGENCY_CALL = 71; // 0x47

public static final int INCOMING_AUTO_REJECTED = 81; // 0x51

public static final int INCOMING_MISSED = 1; // 0x1

public static final int INCOMING_REJECTED = 16; // 0x10

public static final int INVALID_CREDENTIALS = 10; // 0xa

public static final int INVALID_NUMBER = 7; // 0x7

public static final int LIMIT_EXCEEDED = 15; // 0xf

public static final int LOCAL = 3; // 0x3

public static final int LOST_SIGNAL = 14; // 0xe

public static final int LOW_BATTERY = 61; // 0x3d

public static final int MAXIMUM_NUMBER_OF_CALLS_REACHED = 53; // 0x35

public static final int MEDIA_TIMEOUT = 77; // 0x4d

public static final int MMI = 6; // 0x6

public static final int NORMAL = 2; // 0x2

public static final int NORMAL_UNSPECIFIED = 65; // 0x41

public static final int NOT_DISCONNECTED = 0; // 0x0

public static final int NOT_VALID = -1; // 0xffffffff

public static final int NO_PHONE_NUMBER_SUPPLIED = 38; // 0x26

public static final int NUMBER_UNREACHABLE = 8; // 0x8

public static final int OTASP_PROVISIONING_IN_PROCESS = 76; // 0x4c

public static final int OUTGOING_CANCELED = 44; // 0x2c

public static final int OUTGOING_EMERGENCY_CALL_PLACED = 80; // 0x50

public static final int OUTGOING_FAILURE = 43; // 0x2b

public static final int OUT_OF_NETWORK = 11; // 0xb

public static final int OUT_OF_SERVICE = 18; // 0x12

public static final int POWER_OFF = 17; // 0x11

public static final int SERVER_ERROR = 12; // 0xc

public static final int SERVER_UNREACHABLE = 9; // 0x9

public static final int TIMED_OUT = 13; // 0xd

public static final int TOO_MANY_ONGOING_CALLS = 75; // 0x4b

public static final int UNOBTAINABLE_NUMBER = 25; // 0x19

public static final int VIDEO_CALL_NOT_ALLOWED_WHILE_TTY_ENABLED = 50; // 0x32

public static final int VOICEMAIL_NUMBER_MISSING = 40; // 0x28

public static final int WFC_SERVICE_NOT_AVAILABLE_IN_THIS_LOCATION = 79; // 0x4f

public static final int WIFI_LOST = 59; // 0x3b
}

