/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface SurfaceHolder {

public void addCallback(android.view.SurfaceHolder.Callback callback);

public void removeCallback(android.view.SurfaceHolder.Callback callback);

public boolean isCreating();

@Deprecated
public void setType(int type);

public void setFixedSize(int width, int height);

public void setSizeFromLayout();

public void setFormat(int format);

public void setKeepScreenOn(boolean screenOn);

public android.graphics.Canvas lockCanvas();

public android.graphics.Canvas lockCanvas(android.graphics.Rect dirty);

public default android.graphics.Canvas lockHardwareCanvas() { throw new RuntimeException("Stub!"); }

public void unlockCanvasAndPost(android.graphics.Canvas canvas);

public android.graphics.Rect getSurfaceFrame();

public android.view.Surface getSurface();

@Deprecated public static final int SURFACE_TYPE_GPU = 2; // 0x2

@Deprecated public static final int SURFACE_TYPE_HARDWARE = 1; // 0x1

@Deprecated public static final int SURFACE_TYPE_NORMAL = 0; // 0x0

@Deprecated public static final int SURFACE_TYPE_PUSH_BUFFERS = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class BadSurfaceTypeException extends java.lang.RuntimeException {

public BadSurfaceTypeException() { throw new RuntimeException("Stub!"); }

public BadSurfaceTypeException(java.lang.String name) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void surfaceCreated(@android.annotation.NonNull android.view.SurfaceHolder holder);

public void surfaceChanged(@android.annotation.NonNull android.view.SurfaceHolder holder, int format, int width, int height);

public void surfaceDestroyed(@android.annotation.NonNull android.view.SurfaceHolder holder);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback2 extends android.view.SurfaceHolder.Callback {

public void surfaceRedrawNeeded(@android.annotation.NonNull android.view.SurfaceHolder holder);

public default void surfaceRedrawNeededAsync(@android.annotation.NonNull android.view.SurfaceHolder holder, @android.annotation.NonNull java.lang.Runnable drawingFinished) { throw new RuntimeException("Stub!"); }
}

}

