/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// $Id: XPathFactoryConfigurationException.java 446598 2006-09-15 12:55:40Z jeremias $


package javax.xml.xpath;


/**
 * <code>XPathFactoryConfigurationException</code> represents a configuration error in a <code>XPathFactory</code> environment.</p>
 *
 * @author  <a href="mailto:Norman.Walsh@Sun.com">Norman Walsh</a>
 * @author  <a href="mailto:Jeff.Suttor@Sun.com">Jeff Suttor</a>
 * @version $Revision: 446598 $, $Date: 2006-09-15 05:55:40 -0700 (Fri, 15 Sep 2006) $
 * @since 1.5
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class XPathFactoryConfigurationException extends javax.xml.xpath.XPathException {

/**
 * <p>Constructs a new <code>XPathFactoryConfigurationException</code> with the specified detail <code>message</code>.</p>
 *
 * <p>The <code>cause</code> is not initialized.</p>
 *
 * <p>If <code>message</code> is <code>null</code>, then a <code>NullPointerException</code> is thrown.</p>
 *
 * @param message The detail message.
 */

public XPathFactoryConfigurationException(java.lang.String message) { super((java.lang.String)null); throw new RuntimeException("Stub!"); }

/**
 * <p>Constructs a new <code>XPathFactoryConfigurationException</code> with the specified <code>cause</code>.</p>
 *
 * <p>If <code>cause</code> is <code>null</code>, then a <code>NullPointerException</code> is thrown.</p>
 *
 * @param cause The cause.
 *
 * @throws java.lang.NullPointerException if <code>cause</code> is <code>null</code>.
 */

public XPathFactoryConfigurationException(java.lang.Throwable cause) { super((java.lang.String)null); throw new RuntimeException("Stub!"); }
}

