/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.accessibilityservice;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class AccessibilityService extends android.app.Service {

public AccessibilityService() { throw new RuntimeException("Stub!"); }

public abstract void onAccessibilityEvent(android.view.accessibility.AccessibilityEvent event);

public abstract void onInterrupt();

protected void onServiceConnected() { throw new RuntimeException("Stub!"); }

@Deprecated
protected boolean onGesture(int gestureId) { throw new RuntimeException("Stub!"); }

public boolean onGesture(@android.annotation.NonNull android.accessibilityservice.AccessibilityGestureEvent gestureEvent) { throw new RuntimeException("Stub!"); }

protected boolean onKeyEvent(android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public java.util.List<android.view.accessibility.AccessibilityWindowInfo> getWindows() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.util.SparseArray<java.util.List<android.view.accessibility.AccessibilityWindowInfo>> getWindowsOnAllDisplays() { throw new RuntimeException("Stub!"); }

public android.view.accessibility.AccessibilityNodeInfo getRootInActiveWindow() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.view.accessibility.AccessibilityNodeInfo getRootInActiveWindow(int prefetchingStrategy) { throw new RuntimeException("Stub!"); }

public final void disableSelf() { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public android.content.Context createDisplayContext(android.view.Display display) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.Context createWindowContext(int type, @android.annotation.Nullable android.os.Bundle options) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.Context createWindowContext(@android.annotation.NonNull android.view.Display display, int type, @android.annotation.Nullable android.os.Bundle options) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.AccessibilityService.MagnificationController getMagnificationController() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.FingerprintGestureController getFingerprintGestureController() { throw new RuntimeException("Stub!"); }

public final boolean dispatchGesture(@android.annotation.NonNull android.accessibilityservice.GestureDescription gesture, @android.annotation.Nullable android.accessibilityservice.AccessibilityService.GestureResultCallback callback, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.AccessibilityService.SoftKeyboardController getSoftKeyboardController() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.accessibilityservice.InputMethod onCreateInputMethod() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.accessibilityservice.InputMethod getInputMethod() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.AccessibilityButtonController getAccessibilityButtonController() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.AccessibilityButtonController getAccessibilityButtonController(int displayId) { throw new RuntimeException("Stub!"); }

public boolean setCacheEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean clearCachedSubtree(@android.annotation.NonNull android.view.accessibility.AccessibilityNodeInfo node) { throw new RuntimeException("Stub!"); }

public boolean clearCache() { throw new RuntimeException("Stub!"); }

public boolean isNodeInCache(@android.annotation.NonNull android.view.accessibility.AccessibilityNodeInfo node) { throw new RuntimeException("Stub!"); }

public boolean isCacheEnabled() { throw new RuntimeException("Stub!"); }

public void onSystemActionsChanged() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final java.util.List<android.view.accessibility.AccessibilityNodeInfo.AccessibilityAction> getSystemActions() { throw new RuntimeException("Stub!"); }

public final boolean performGlobalAction(int action) { throw new RuntimeException("Stub!"); }

public android.view.accessibility.AccessibilityNodeInfo findFocus(int focus) { throw new RuntimeException("Stub!"); }

public final android.accessibilityservice.AccessibilityServiceInfo getServiceInfo() { throw new RuntimeException("Stub!"); }

public final void setServiceInfo(android.accessibilityservice.AccessibilityServiceInfo info) { throw new RuntimeException("Stub!"); }

public java.lang.Object getSystemService(@androidx.annotation.RecentlyNonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

public void takeScreenshot(int displayId, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.accessibilityservice.AccessibilityService.TakeScreenshotCallback callback) { throw new RuntimeException("Stub!"); }

public void setAccessibilityFocusAppearance(int strokeWidth, int color) { throw new RuntimeException("Stub!"); }

public final android.os.IBinder onBind(android.content.Intent intent) { throw new RuntimeException("Stub!"); }

public void setGestureDetectionPassthroughRegion(int displayId, @android.annotation.NonNull android.graphics.Region region) { throw new RuntimeException("Stub!"); }

public void setTouchExplorationPassthroughRegion(int displayId, @android.annotation.NonNull android.graphics.Region region) { throw new RuntimeException("Stub!"); }

public void setAnimationScale(float scale) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.accessibilityservice.TouchInteractionController getTouchInteractionController(int displayId) { throw new RuntimeException("Stub!"); }

public static final int ERROR_TAKE_SCREENSHOT_INTERNAL_ERROR = 1; // 0x1

public static final int ERROR_TAKE_SCREENSHOT_INTERVAL_TIME_SHORT = 3; // 0x3

public static final int ERROR_TAKE_SCREENSHOT_INVALID_DISPLAY = 4; // 0x4

public static final int ERROR_TAKE_SCREENSHOT_NO_ACCESSIBILITY_ACCESS = 2; // 0x2

public static final int GESTURE_2_FINGER_DOUBLE_TAP = 20; // 0x14

public static final int GESTURE_2_FINGER_DOUBLE_TAP_AND_HOLD = 40; // 0x28

public static final int GESTURE_2_FINGER_SINGLE_TAP = 19; // 0x13

public static final int GESTURE_2_FINGER_SWIPE_DOWN = 26; // 0x1a

public static final int GESTURE_2_FINGER_SWIPE_LEFT = 27; // 0x1b

public static final int GESTURE_2_FINGER_SWIPE_RIGHT = 28; // 0x1c

public static final int GESTURE_2_FINGER_SWIPE_UP = 25; // 0x19

public static final int GESTURE_2_FINGER_TRIPLE_TAP = 21; // 0x15

public static final int GESTURE_2_FINGER_TRIPLE_TAP_AND_HOLD = 43; // 0x2b

public static final int GESTURE_3_FINGER_DOUBLE_TAP = 23; // 0x17

public static final int GESTURE_3_FINGER_DOUBLE_TAP_AND_HOLD = 41; // 0x29

public static final int GESTURE_3_FINGER_SINGLE_TAP = 22; // 0x16

public static final int GESTURE_3_FINGER_SINGLE_TAP_AND_HOLD = 44; // 0x2c

public static final int GESTURE_3_FINGER_SWIPE_DOWN = 30; // 0x1e

public static final int GESTURE_3_FINGER_SWIPE_LEFT = 31; // 0x1f

public static final int GESTURE_3_FINGER_SWIPE_RIGHT = 32; // 0x20

public static final int GESTURE_3_FINGER_SWIPE_UP = 29; // 0x1d

public static final int GESTURE_3_FINGER_TRIPLE_TAP = 24; // 0x18

public static final int GESTURE_3_FINGER_TRIPLE_TAP_AND_HOLD = 45; // 0x2d

public static final int GESTURE_4_FINGER_DOUBLE_TAP = 38; // 0x26

public static final int GESTURE_4_FINGER_DOUBLE_TAP_AND_HOLD = 42; // 0x2a

public static final int GESTURE_4_FINGER_SINGLE_TAP = 37; // 0x25

public static final int GESTURE_4_FINGER_SWIPE_DOWN = 34; // 0x22

public static final int GESTURE_4_FINGER_SWIPE_LEFT = 35; // 0x23

public static final int GESTURE_4_FINGER_SWIPE_RIGHT = 36; // 0x24

public static final int GESTURE_4_FINGER_SWIPE_UP = 33; // 0x21

public static final int GESTURE_4_FINGER_TRIPLE_TAP = 39; // 0x27

public static final int GESTURE_DOUBLE_TAP = 17; // 0x11

public static final int GESTURE_DOUBLE_TAP_AND_HOLD = 18; // 0x12

public static final int GESTURE_SWIPE_DOWN = 2; // 0x2

public static final int GESTURE_SWIPE_DOWN_AND_LEFT = 15; // 0xf

public static final int GESTURE_SWIPE_DOWN_AND_RIGHT = 16; // 0x10

public static final int GESTURE_SWIPE_DOWN_AND_UP = 8; // 0x8

public static final int GESTURE_SWIPE_LEFT = 3; // 0x3

public static final int GESTURE_SWIPE_LEFT_AND_DOWN = 10; // 0xa

public static final int GESTURE_SWIPE_LEFT_AND_RIGHT = 5; // 0x5

public static final int GESTURE_SWIPE_LEFT_AND_UP = 9; // 0x9

public static final int GESTURE_SWIPE_RIGHT = 4; // 0x4

public static final int GESTURE_SWIPE_RIGHT_AND_DOWN = 12; // 0xc

public static final int GESTURE_SWIPE_RIGHT_AND_LEFT = 6; // 0x6

public static final int GESTURE_SWIPE_RIGHT_AND_UP = 11; // 0xb

public static final int GESTURE_SWIPE_UP = 1; // 0x1

public static final int GESTURE_SWIPE_UP_AND_DOWN = 7; // 0x7

public static final int GESTURE_SWIPE_UP_AND_LEFT = 13; // 0xd

public static final int GESTURE_SWIPE_UP_AND_RIGHT = 14; // 0xe

public static final int GESTURE_UNKNOWN = 0; // 0x0

public static final int GLOBAL_ACTION_ACCESSIBILITY_ALL_APPS = 14; // 0xe

public static final int GLOBAL_ACTION_ACCESSIBILITY_BUTTON = 11; // 0xb

public static final int GLOBAL_ACTION_ACCESSIBILITY_BUTTON_CHOOSER = 12; // 0xc

public static final int GLOBAL_ACTION_ACCESSIBILITY_SHORTCUT = 13; // 0xd

public static final int GLOBAL_ACTION_BACK = 1; // 0x1

public static final int GLOBAL_ACTION_DISMISS_NOTIFICATION_SHADE = 15; // 0xf

public static final int GLOBAL_ACTION_DPAD_CENTER = 20; // 0x14

public static final int GLOBAL_ACTION_DPAD_DOWN = 17; // 0x11

public static final int GLOBAL_ACTION_DPAD_LEFT = 18; // 0x12

public static final int GLOBAL_ACTION_DPAD_RIGHT = 19; // 0x13

public static final int GLOBAL_ACTION_DPAD_UP = 16; // 0x10

public static final int GLOBAL_ACTION_HOME = 2; // 0x2

public static final int GLOBAL_ACTION_KEYCODE_HEADSETHOOK = 10; // 0xa

public static final int GLOBAL_ACTION_LOCK_SCREEN = 8; // 0x8

public static final int GLOBAL_ACTION_NOTIFICATIONS = 4; // 0x4

public static final int GLOBAL_ACTION_POWER_DIALOG = 6; // 0x6

public static final int GLOBAL_ACTION_QUICK_SETTINGS = 5; // 0x5

public static final int GLOBAL_ACTION_RECENTS = 3; // 0x3

public static final int GLOBAL_ACTION_TAKE_SCREENSHOT = 9; // 0x9

public static final int GLOBAL_ACTION_TOGGLE_SPLIT_SCREEN = 7; // 0x7

public static final java.lang.String SERVICE_INTERFACE = "android.accessibilityservice.AccessibilityService";

public static final java.lang.String SERVICE_META_DATA = "android.accessibilityservice";

public static final int SHOW_MODE_AUTO = 0; // 0x0

public static final int SHOW_MODE_HIDDEN = 1; // 0x1

public static final int SHOW_MODE_IGNORE_HARD_KEYBOARD = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class GestureResultCallback {

public GestureResultCallback() { throw new RuntimeException("Stub!"); }

public void onCompleted(android.accessibilityservice.GestureDescription gestureDescription) { throw new RuntimeException("Stub!"); }

public void onCancelled(android.accessibilityservice.GestureDescription gestureDescription) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MagnificationController {

MagnificationController() { throw new RuntimeException("Stub!"); }

public void addListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.MagnificationController.OnMagnificationChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.MagnificationController.OnMagnificationChangedListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public boolean removeListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.MagnificationController.OnMagnificationChangedListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.accessibilityservice.MagnificationConfig getMagnificationConfig() { throw new RuntimeException("Stub!"); }

@Deprecated
public float getScale() { throw new RuntimeException("Stub!"); }

@Deprecated
public float getCenterX() { throw new RuntimeException("Stub!"); }

@Deprecated
public float getCenterY() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.graphics.Region getMagnificationRegion() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Region getCurrentMagnificationRegion() { throw new RuntimeException("Stub!"); }

public boolean reset(boolean animate) { throw new RuntimeException("Stub!"); }

public boolean resetCurrentMagnification(boolean animate) { throw new RuntimeException("Stub!"); }

public boolean setMagnificationConfig(@android.annotation.NonNull android.accessibilityservice.MagnificationConfig config, boolean animate) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean setScale(float scale, boolean animate) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean setCenter(float centerX, float centerY, boolean animate) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMagnificationChangedListener {

@Deprecated
public void onMagnificationChanged(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.MagnificationController controller, @android.annotation.NonNull android.graphics.Region region, float scale, float centerX, float centerY);

public default void onMagnificationChanged(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.MagnificationController controller, @android.annotation.NonNull android.graphics.Region region, @android.annotation.NonNull android.accessibilityservice.MagnificationConfig config) { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ScreenshotResult {

private ScreenshotResult() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.ColorSpace getColorSpace() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.HardwareBuffer getHardwareBuffer() { throw new RuntimeException("Stub!"); }

public long getTimestamp() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SoftKeyboardController {

SoftKeyboardController() { throw new RuntimeException("Stub!"); }

public void addOnShowModeChangedListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addOnShowModeChangedListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public boolean removeOnShowModeChangedListener(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener) { throw new RuntimeException("Stub!"); }

public int getShowMode() { throw new RuntimeException("Stub!"); }

public boolean setShowMode(int showMode) { throw new RuntimeException("Stub!"); }

public boolean switchToInputMethod(@android.annotation.NonNull java.lang.String imeId) { throw new RuntimeException("Stub!"); }

public int setInputMethodEnabled(@android.annotation.NonNull java.lang.String imeId, boolean enabled) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

public static final int ENABLE_IME_FAIL_BY_ADMIN = 1; // 0x1

public static final int ENABLE_IME_FAIL_UNKNOWN = 2; // 0x2

public static final int ENABLE_IME_SUCCESS = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnShowModeChangedListener {

public void onShowModeChanged(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.SoftKeyboardController controller, int showMode);
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TakeScreenshotCallback {

public void onSuccess(@android.annotation.NonNull android.accessibilityservice.AccessibilityService.ScreenshotResult screenshot);

public void onFailure(int errorCode);
}

}

