/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaCas implements java.lang.AutoCloseable {

public MediaCas(int casSystemId) throws android.media.MediaCasException.UnsupportedCasException { throw new RuntimeException("Stub!"); }

public MediaCas(@android.annotation.NonNull android.content.Context context, int casSystemId, @android.annotation.Nullable java.lang.String tvInputServiceSessionId, int priorityHint) throws android.media.MediaCasException.UnsupportedCasException { throw new RuntimeException("Stub!"); }

public MediaCas(@android.annotation.NonNull android.content.Context context, int casSystemId, @android.annotation.Nullable java.lang.String tvInputServiceSessionId, int priorityHint, @android.annotation.Nullable android.os.Handler handler, @android.annotation.Nullable android.media.MediaCas.EventListener listener) throws android.media.MediaCasException.UnsupportedCasException { throw new RuntimeException("Stub!"); }

public static boolean isSystemIdSupported(int CA_system_id) { throw new RuntimeException("Stub!"); }

public static android.media.MediaCas.PluginDescriptor[] enumeratePlugins() { throw new RuntimeException("Stub!"); }

public void setEventListener(@android.annotation.Nullable android.media.MediaCas.EventListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setPrivateData(@android.annotation.NonNull byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public android.media.MediaCas.Session openSession() throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaCas.Session openSession(int sessionUsage, int scramblingMode) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void processEmm(@android.annotation.NonNull byte[] data, int offset, int length) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void processEmm(@android.annotation.NonNull byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void sendEvent(int event, int arg, @android.annotation.Nullable byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void provision(@android.annotation.NonNull java.lang.String provisionString) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void refreshEntitlements(int refreshType, @android.annotation.Nullable byte[] refreshData) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public static final int PLUGIN_STATUS_PHYSICAL_MODULE_CHANGED = 0; // 0x0

public static final int PLUGIN_STATUS_SESSION_NUMBER_CHANGED = 1; // 0x1

public static final int SCRAMBLING_MODE_AES128 = 9; // 0x9

public static final int SCRAMBLING_MODE_AES_ECB = 10; // 0xa

public static final int SCRAMBLING_MODE_AES_SCTE52 = 11; // 0xb

public static final int SCRAMBLING_MODE_DVB_CISSA_V1 = 6; // 0x6

public static final int SCRAMBLING_MODE_DVB_CSA1 = 1; // 0x1

public static final int SCRAMBLING_MODE_DVB_CSA2 = 2; // 0x2

public static final int SCRAMBLING_MODE_DVB_CSA3_ENHANCE = 5; // 0x5

public static final int SCRAMBLING_MODE_DVB_CSA3_MINIMAL = 4; // 0x4

public static final int SCRAMBLING_MODE_DVB_CSA3_STANDARD = 3; // 0x3

public static final int SCRAMBLING_MODE_DVB_IDSA = 7; // 0x7

public static final int SCRAMBLING_MODE_MULTI2 = 8; // 0x8

public static final int SCRAMBLING_MODE_RESERVED = 0; // 0x0

public static final int SCRAMBLING_MODE_TDES_ECB = 12; // 0xc

public static final int SCRAMBLING_MODE_TDES_SCTE52 = 13; // 0xd

public static final int SESSION_USAGE_LIVE = 0; // 0x0

public static final int SESSION_USAGE_PLAYBACK = 1; // 0x1

public static final int SESSION_USAGE_RECORD = 2; // 0x2

public static final int SESSION_USAGE_TIMESHIFT = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface EventListener {

public void onEvent(@android.annotation.NonNull android.media.MediaCas mediaCas, int event, int arg, @android.annotation.Nullable byte[] data);

public default void onSessionEvent(@android.annotation.NonNull android.media.MediaCas mediaCas, @android.annotation.NonNull android.media.MediaCas.Session session, int event, int arg, @android.annotation.Nullable byte[] data) { throw new RuntimeException("Stub!"); }

public default void onPluginStatusUpdate(@android.annotation.NonNull android.media.MediaCas mediaCas, int status, int arg) { throw new RuntimeException("Stub!"); }

public default void onResourceLost(@android.annotation.NonNull android.media.MediaCas mediaCas) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PluginDescriptor {

PluginDescriptor() { throw new RuntimeException("Stub!"); }

public int getSystemId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Session implements java.lang.AutoCloseable {

Session() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public void setPrivateData(@android.annotation.NonNull byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void processEcm(@android.annotation.NonNull byte[] data, int offset, int length) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void processEcm(@android.annotation.NonNull byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

public void sendSessionEvent(int event, int arg, @android.annotation.Nullable byte[] data) throws android.media.MediaCasException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getSessionId() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }
}

}

