/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

import android.os.Parcelable;

/**
 * Class that describes static IP configuration.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class StaticIpConfiguration implements android.os.Parcelable {

StaticIpConfiguration() { throw new RuntimeException("Stub!"); }

/**
 * Get the static IP address included in the configuration.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.LinkAddress getIpAddress() { throw new RuntimeException("Stub!"); }

/**
 * Get the gateway included in the configuration.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.net.InetAddress getGateway() { throw new RuntimeException("Stub!"); }

/**
 * Get the DNS servers included in the configuration.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.net.InetAddress> getDnsServers() { throw new RuntimeException("Stub!"); }

/**
 * Get a {@link java.lang.String String} containing the comma separated domains to search when resolving host
 * names on this link, in priority order.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getDomains() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.StaticIpConfiguration> CREATOR;
static { CREATOR = null; }
/**
 * Helper class to build a new instance of {@link android.net.StaticIpConfiguration StaticIpConfiguration}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Set the IP address to be included in the configuration.
 *
 * @param ipAddress This value cannot be {@code null}.
 * @return The {@link android.net.StaticIpConfiguration.Builder Builder} for chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.StaticIpConfiguration.Builder setIpAddress(@android.annotation.NonNull android.net.LinkAddress ipAddress) { throw new RuntimeException("Stub!"); }

/**
 * Set the address of the gateway to be included in the configuration; null by default.
 * @param gateway This value may be {@code null}.
 * @return The {@link android.net.StaticIpConfiguration.Builder Builder} for chaining.
 */

@android.annotation.NonNull
public android.net.StaticIpConfiguration.Builder setGateway(@android.annotation.Nullable java.net.InetAddress gateway) { throw new RuntimeException("Stub!"); }

/**
 * Set the addresses of the DNS servers included in the configuration; empty by default.
 * @param dnsServers This value cannot be {@code null}.
 * @return The {@link android.net.StaticIpConfiguration.Builder Builder} for chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.StaticIpConfiguration.Builder setDnsServers(@android.annotation.NonNull java.lang.Iterable<java.net.InetAddress> dnsServers) { throw new RuntimeException("Stub!"); }

/**
 * Sets the DNS domain search path to be used on the link; null by default.
 * @param newDomains A {@link java.lang.String String} containing the comma separated domains to search when
 *                   resolving host names on this link, in priority order.
 * This value may be {@code null}.
 * @return The {@link android.net.StaticIpConfiguration.Builder Builder} for chaining.
 */

@android.annotation.NonNull
public android.net.StaticIpConfiguration.Builder setDomains(@android.annotation.Nullable java.lang.String newDomains) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.net.StaticIpConfiguration StaticIpConfiguration} from the parameters in this {@link android.net.StaticIpConfiguration.Builder Builder}.
 * @return The newly created StaticIpConfiguration.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if an invalid configuration is attempted, e.g.
 * if an IP Address was not configured via {@link #setIpAddress(android.net.LinkAddress)}.
 */

@android.annotation.NonNull
public android.net.StaticIpConfiguration build() { throw new RuntimeException("Stub!"); }
}

}

