/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;

import android.os.Handler;

/**
 * The resources of the Aware service.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AwareResources implements android.os.Parcelable {

/**
 * Construct a {@link android.net.wifi.aware.AwareResources AwareResources} object, which represents the currently available Aware
 * resources.
 *
 * @param availableDataPathsCount Number of available Aware data-path.
 * Value is 0 or greater
 * @param availablePublishSessionsCount Number of available Aware publish sessions.
 * Value is 0 or greater
 * @param availableSubscribeSessionsCount Number of available Aware subscribe sessions.

 * Value is 0 or greater
 */

public AwareResources(int availableDataPathsCount, int availablePublishSessionsCount, int availableSubscribeSessionsCount) { throw new RuntimeException("Stub!"); }

/**
 * Return the number of Aware data-paths (also known as NDPs - NAN Data Paths) which an app
 * could create. Please refer to the {@link android.net.wifi.aware.WifiAwareNetworkSpecifier WifiAwareNetworkSpecifier} to create
 * a Network Specifier and request a data-path.
 * <p>
 * Note that these resources aren't reserved - other apps could use them by the time you
 * attempt to create a data-path.
 * </p>
 * @return A Non-negative integer, number of data-paths that could be created.

 * Value is 0 or greater
 */

public int getAvailableDataPathsCount() { throw new RuntimeException("Stub!"); }

/**
 * Return the number of Aware publish sessions which an app could create. Please refer to the
 * {@link android.net.wifi.aware.WifiAwareSession#publish(android.net.wifi.aware.PublishConfig,android.net.wifi.aware.DiscoverySessionCallback,android.os.Handler) WifiAwareSession#publish(PublishConfig, DiscoverySessionCallback, Handler)}
 * to create a publish session.
 * <p>
 * Note that these resources aren't reserved - other apps could use them by the time you
 * attempt to create a publish session.
 * </p>
 * @return A Non-negative integer, number of publish sessions that could be created.

 * Value is 0 or greater
 */

public int getAvailablePublishSessionsCount() { throw new RuntimeException("Stub!"); }

/**
 * Return the number of Aware subscribe sessions which an app could create. Please refer to the
 * {@link android.net.wifi.aware.WifiAwareSession#subscribe(android.net.wifi.aware.SubscribeConfig,android.net.wifi.aware.DiscoverySessionCallback,android.os.Handler) WifiAwareSession#subscribe(SubscribeConfig, DiscoverySessionCallback, Handler)}
 * to create a subscribe session.
 * <p>
 * Note that these resources aren't reserved - other apps could use them by the time you
 * attempt to create a subscribe session.
 * </p>
 * @return A Non-negative integer, number of subscribe sessions that could be created.

 * Value is 0 or greater
 */

public int getAvailableSubscribeSessionsCount() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.AwareResources> CREATOR;
static { CREATOR = null; }
}

