/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.inspector;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface PropertyMapper {

public int mapBoolean(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapByte(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapChar(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapDouble(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapFloat(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapInt(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapLong(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapShort(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapObject(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapColor(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapGravity(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapIntEnum(@android.annotation.NonNull java.lang.String name, int attributeId, @android.annotation.NonNull java.util.function.IntFunction<java.lang.String> mapping);

public int mapResourceId(@android.annotation.NonNull java.lang.String name, int attributeId);

public int mapIntFlag(@android.annotation.NonNull java.lang.String name, int attributeId, @android.annotation.NonNull java.util.function.IntFunction<java.util.Set<java.lang.String>> mapping);
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PropertyConflictException extends java.lang.RuntimeException {

public PropertyConflictException(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.lang.String newPropertyType, @android.annotation.NonNull java.lang.String existingPropertyType) { throw new RuntimeException("Stub!"); }
}

}

