/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;


/**
 * This class represents a field in the {@code OutcomeReceiver}, which is an input to the {@link android.adservices.adselection.AdSelectionManager#selectAds  } in the {@link android.adservices.adselection.AdSelectionManager AdSelectionManager}. This field is populated in the
 * case of a successful {@link android.adservices.adselection.AdSelectionManager#selectAds AdSelectionManager#selectAds} call.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdSelectionOutcome {

AdSelectionOutcome() { throw new RuntimeException("Stub!"); }

/**
 * Returns the renderUri that the AdSelection returns.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.Uri getRenderUri() { throw new RuntimeException("Stub!"); }

/**
 * Returns the adSelectionId that identifies the AdSelection.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public long getAdSelectionId() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the mAdSelectionId.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionOutcome.Builder setAdSelectionId(long adSelectionId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the RenderUri.
 * @param renderUri This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionOutcome.Builder setRenderUri(@android.annotation.NonNull android.net.Uri renderUri) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.AdSelectionOutcome AdSelectionOutcome} instance.
 *
 * @throws java.lang.IllegalArgumentException if the adSelectionIid is not set
 * @throws java.lang.NullPointerException if the RenderUri is null

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.AdSelectionOutcome build() { throw new RuntimeException("Stub!"); }
}

}

