/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox.sdkprovider;

import android.os.IBinder;
import android.app.Activity;
import android.view.View;

/**
 * This is used to notify the SDK when an {@link android.app.Activity Activity} is created for it.
 *
 * <p>When an SDK wants to start an {@link android.app.Activity Activity}, it should register an implementation of this
 * class by calling {@link android.app.sdksandbox.sdkprovider.SdkSandboxController#registerSdkSandboxActivityHandler(android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler)  } that will
 * return an {@link android.os.IBinder} identifier for the registered {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} to The SDK.
 *
 * <p>The SDK should be notified about the {@link android.app.Activity Activity} creation by calling {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler#onActivityCreated(android.app.Activity)  } which happens when the caller app calls
 * {@link android.app.sdksandbox.SdkSandboxManager#startSdkSandboxActivity(Activity, IBinder)} using
 * the same {@link android.os.IBinder IBinder} identifier for the registered {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface SdkSandboxActivityHandler {

/**
 * Notifies SDK when an {@link android.app.Activity Activity} gets created.
 *
 * <p>This function is called synchronously from the main thread of the {@link android.app.Activity Activity} that is
 * getting created.
 *
 * <p>SDK is expected to call {@link android.app.Activity#setContentView(android.view.View) Activity#setContentView(View)} to the passed {@link android.app.Activity Activity} object to populate the view.
 *
 * @param activity the {@link android.app.Activity Activity} gets created

 * This value cannot be {@code null}.
 */

public void onActivityCreated(@android.annotation.NonNull android.app.Activity activity);
}

