/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Path {

public Path() { throw new RuntimeException("Stub!"); }

public Path(@android.annotation.Nullable android.graphics.Path src) { throw new RuntimeException("Stub!"); }

public void reset() { throw new RuntimeException("Stub!"); }

public void rewind() { throw new RuntimeException("Stub!"); }

public void set(@android.annotation.NonNull android.graphics.Path src) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.PathIterator getPathIterator() { throw new RuntimeException("Stub!"); }

public boolean op(@android.annotation.NonNull android.graphics.Path path, @android.annotation.NonNull android.graphics.Path.Op op) { throw new RuntimeException("Stub!"); }

public boolean op(@android.annotation.NonNull android.graphics.Path path1, @android.annotation.NonNull android.graphics.Path path2, @android.annotation.NonNull android.graphics.Path.Op op) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isConvex() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Path.FillType getFillType() { throw new RuntimeException("Stub!"); }

public void setFillType(@android.annotation.NonNull android.graphics.Path.FillType ft) { throw new RuntimeException("Stub!"); }

public boolean isInverseFillType() { throw new RuntimeException("Stub!"); }

public void toggleInverseFillType() { throw new RuntimeException("Stub!"); }

public boolean isEmpty() { throw new RuntimeException("Stub!"); }

public boolean isRect(@android.annotation.Nullable android.graphics.RectF rect) { throw new RuntimeException("Stub!"); }

public void computeBounds(@android.annotation.NonNull android.graphics.RectF bounds, boolean exact) { throw new RuntimeException("Stub!"); }

public void incReserve(int extraPtCount) { throw new RuntimeException("Stub!"); }

public void moveTo(float x, float y) { throw new RuntimeException("Stub!"); }

public void rMoveTo(float dx, float dy) { throw new RuntimeException("Stub!"); }

public void lineTo(float x, float y) { throw new RuntimeException("Stub!"); }

public void rLineTo(float dx, float dy) { throw new RuntimeException("Stub!"); }

public void quadTo(float x1, float y1, float x2, float y2) { throw new RuntimeException("Stub!"); }

public void rQuadTo(float dx1, float dy1, float dx2, float dy2) { throw new RuntimeException("Stub!"); }

public void conicTo(float x1, float y1, float x2, float y2, float weight) { throw new RuntimeException("Stub!"); }

public void rConicTo(float dx1, float dy1, float dx2, float dy2, float weight) { throw new RuntimeException("Stub!"); }

public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) { throw new RuntimeException("Stub!"); }

public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) { throw new RuntimeException("Stub!"); }

public void arcTo(@android.annotation.NonNull android.graphics.RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) { throw new RuntimeException("Stub!"); }

public void arcTo(@android.annotation.NonNull android.graphics.RectF oval, float startAngle, float sweepAngle) { throw new RuntimeException("Stub!"); }

public void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public void addRect(@android.annotation.NonNull android.graphics.RectF rect, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addRect(float left, float top, float right, float bottom, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addOval(@android.annotation.NonNull android.graphics.RectF oval, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addOval(float left, float top, float right, float bottom, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addCircle(float x, float y, float radius, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addArc(@android.annotation.NonNull android.graphics.RectF oval, float startAngle, float sweepAngle) { throw new RuntimeException("Stub!"); }

public void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) { throw new RuntimeException("Stub!"); }

public void addRoundRect(@android.annotation.NonNull android.graphics.RectF rect, float rx, float ry, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addRoundRect(float left, float top, float right, float bottom, float rx, float ry, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addRoundRect(@android.annotation.NonNull android.graphics.RectF rect, @android.annotation.NonNull float[] radii, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addRoundRect(float left, float top, float right, float bottom, @android.annotation.NonNull float[] radii, @android.annotation.NonNull android.graphics.Path.Direction dir) { throw new RuntimeException("Stub!"); }

public void addPath(@android.annotation.NonNull android.graphics.Path src, float dx, float dy) { throw new RuntimeException("Stub!"); }

public void addPath(@android.annotation.NonNull android.graphics.Path src) { throw new RuntimeException("Stub!"); }

public void addPath(@android.annotation.NonNull android.graphics.Path src, @android.annotation.NonNull android.graphics.Matrix matrix) { throw new RuntimeException("Stub!"); }

public void offset(float dx, float dy, @android.annotation.Nullable android.graphics.Path dst) { throw new RuntimeException("Stub!"); }

public void offset(float dx, float dy) { throw new RuntimeException("Stub!"); }

public void setLastPoint(float dx, float dy) { throw new RuntimeException("Stub!"); }

public void transform(@android.annotation.NonNull android.graphics.Matrix matrix, @android.annotation.Nullable android.graphics.Path dst) { throw new RuntimeException("Stub!"); }

public void transform(@android.annotation.NonNull android.graphics.Matrix matrix) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] approximate(float acceptableError) { throw new RuntimeException("Stub!"); }

public int getGenerationId() { throw new RuntimeException("Stub!"); }

public boolean isInterpolatable(@android.annotation.NonNull android.graphics.Path otherPath) { throw new RuntimeException("Stub!"); }

public boolean interpolate(@android.annotation.NonNull android.graphics.Path otherPath, float t, @android.annotation.NonNull android.graphics.Path interpolatedPath) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Direction {
CW,
CCW;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum FillType {
WINDING,
EVEN_ODD,
INVERSE_WINDING,
INVERSE_EVEN_ODD;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Op {
DIFFERENCE,
INTERSECT,
UNION,
XOR,
REVERSE_DIFFERENCE;
}

}

