/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import java.util.concurrent.Executor;
import android.os.OutcomeReceiver;
import android.health.connect.datatypes.Record;
import android.health.connect.datatypes.DataOrigin;

/**
 * Class to represent a request based on time range and data origin filters for {@link android.health.connect.HealthConnectManager#readRecords(android.health.connect.ReadRecordsRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  }
 *
 * @param <T> the type of the Record for the request
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReadRecordsRequestUsingFilters<T extends android.health.connect.datatypes.Record> extends android.health.connect.ReadRecordsRequest<T> {

ReadRecordsRequestUsingFilters() { throw new RuntimeException("Stub!"); }

/**
 * Returns time range b/w which the read operation is to be performed
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.TimeRangeFilter getTimeRangeFilter() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of {@link android.health.connect.datatypes.DataOrigin data origins} to be read, or empty list for no filter

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.health.connect.datatypes.DataOrigin> getDataOrigins() { throw new RuntimeException("Stub!"); }

/**
 * Returns maximum number of records to be returned by the read operation
 * @return Value is between 1 and 5000 inclusive
 */

public int getPageSize() { throw new RuntimeException("Stub!"); }

/** Returns page token to read the current page of the result. -1 if none available */

public long getPageToken() { throw new RuntimeException("Stub!"); }

/** Returns ordering of results to be returned */

public boolean isAscending() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.ReadRecordsRequestUsingFilters ReadRecordsRequestUsingFilters} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder<T extends android.health.connect.datatypes.Record> {

/**
 * @param recordType Class object of {@link android.health.connect.datatypes.Record Record} type that needs to be read

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.Class<T> recordType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the data origin filter based on which the read operation is to be performed
 *
 * @param dataOrigin Adds {@link android.health.connect.datatypes.DataOrigin DataOrigin} for which to read records.
 *     <p>If no {@link android.health.connect.datatypes.DataOrigin DataOrigin} is added then records by all {@link android.health.connect.datatypes.DataOrigin DataOrigin}s will be
 *     read
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters.Builder<T> addDataOrigins(@android.annotation.NonNull android.health.connect.datatypes.DataOrigin dataOrigin) { throw new RuntimeException("Stub!"); }

/**
 * Sets time range b/w which the read operation is to be performed
 *
 * @param timeRangeFilter Time range b/w which the read operation is to be performed.
 *     <p>If not time range filter is present all the records will be read without any time
 *     constraints.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters.Builder<T> setTimeRangeFilter(@android.annotation.Nullable android.health.connect.TimeRangeFilter timeRangeFilter) { throw new RuntimeException("Stub!"); }

/**
 * Sets maximum number of records to be returned by the read operation
 *
 * @param pageSize number of records to be returned by the read operation.
 *     <p>This sets to limit number of rows returned by a read. If not set default is 1000
 *     and maximum of 5000 records can be sent.
 
 * Value is between 1 and 5000 inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters.Builder<T> setPageSize(int pageSize) { throw new RuntimeException("Stub!"); }

/**
 * Sets page token to read the requested page of the result.
 *
 * @param pageToken to read the requested page of the result. -1 if none available

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters.Builder<T> setPageToken(long pageToken) { throw new RuntimeException("Stub!"); }

/**
 * Sets ordering of results to be returned based on start time. Ordering cannot be set along
 * with page token for subsequent requests. IllegalState exception is thrown when ordering
 * is set along with the page token.
 *
 * @param ascending specifies sorting order of results, if set to true records are sorted on
 *     start time in ascending fashion, else if set to false then in descending.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters.Builder<T> setAscending(boolean ascending) { throw new RuntimeException("Stub!"); }

/**
 * Returns an Object of {@link android.health.connect.ReadRecordsRequestUsingFilters ReadRecordsRequestUsingFilters}
 *
 * <p>For subsequent read requests, {@link android.health.connect.ReadRecordsRequestUsingFilters ReadRecordsRequestUsingFilters} does not allow
 * both pageToken and sort order to be set together.
 *
 * <p>If pageToken is set then records will be sorted in same order as the previous result
 *
 * <p>If both pageToken and sortOrder are not set then by default records will be sorted by
 * start time in ascending order.
 *
 * @throws java.lang.IllegalStateException if both pageToken and sort order is set.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingFilters<T> build() { throw new RuntimeException("Stub!"); }
}

}

