/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.units.Power;

/**
 * Captures the BMR of a user. Each record represents the energy a user would burn if at rest all
 * day, based on their height and weight.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BasalMetabolicRateRecord extends android.health.connect.datatypes.InstantRecord {

BasalMetabolicRateRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return basalMetabolicRate

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Power getBasalMetabolicRate() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier get total basal calories burnt using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Energy> BASAL_CALORIES_TOTAL;
static { BASAL_CALORIES_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.BasalMetabolicRateRecord BasalMetabolicRateRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param basalMetabolicRate Basal metabolic rate, in {@link android.health.connect.datatypes.units.Power Power} unit. Required field.
 *     Valid range: 0-10000 kcal/day.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, @android.annotation.NonNull android.health.connect.datatypes.units.Power basalMetabolicRate) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalMetabolicRateRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalMetabolicRateRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.BasalMetabolicRateRecord BasalMetabolicRateRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BasalMetabolicRateRecord build() { throw new RuntimeException("Stub!"); }
}

}

