/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.datatypes.units.Pressure;

/**
 * Captures the blood pressure of a user. Each record represents a single instantaneous blood
 * pressure reading.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BloodPressureRecord extends android.health.connect.datatypes.InstantRecord {

BloodPressureRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return measurementLocation

 * Value is {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM}, or {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM}
 */

public int getMeasurementLocation() { throw new RuntimeException("Stub!"); }

/**
 * @return systolic

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Pressure getSystolic() { throw new RuntimeException("Stub!"); }

/**
 * @return diastolic

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Pressure getDiastolic() { throw new RuntimeException("Stub!"); }

/**
 * @return bodyPosition

 * Value is {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_UNKNOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_STANDING_UP}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_SITTING_DOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_LYING_DOWN}, or {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_RECLINING}
 */

public int getBodyPosition() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Identifier for Blood Pressure Measurement Location */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BloodPressureMeasurementLocation {

BloodPressureMeasurementLocation() { throw new RuntimeException("Stub!"); }

/** Blood pressure measurement location constant for the left upper arm. */

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM = 3; // 0x3

/** Blood pressure measurement location constant for the left wrist. */

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST = 1; // 0x1

/** Blood pressure measurement location constant for the right upper arm. */

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM = 4; // 0x4

/** Blood pressure measurement location constant for the right wrist. */

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST = 2; // 0x2

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN = 0; // 0x0
}

/** Identifier for body position */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BodyPosition {

BodyPosition() { throw new RuntimeException("Stub!"); }

/** Body position constant representing lying down. */

public static final int BODY_POSITION_LYING_DOWN = 3; // 0x3

/** Body position constant representing semi-recumbent (partially reclining) pose. */

public static final int BODY_POSITION_RECLINING = 4; // 0x4

/** Body position constant representing sitting down. */

public static final int BODY_POSITION_SITTING_DOWN = 2; // 0x2

/** Body position constant representing standing up. */

public static final int BODY_POSITION_STANDING_UP = 1; // 0x1

/** Body position unknown / not identified. */

public static final int BODY_POSITION_UNKNOWN = 0; // 0x0
}

/** Builder class for {@link android.health.connect.datatypes.BloodPressureRecord BloodPressureRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param measurementLocation The arm and part of the arm where the measurement was taken.
 *     Optional field. Allowed values: {@link android.health.connect.datatypes.BodyTemperatureMeasurementLocation BodyTemperatureMeasurementLocation}.
 * Value is {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST}, {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM}, or {@link android.health.connect.datatypes.BloodPressureRecord.BloodPressureMeasurementLocation#BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM}
 * @param systolic Systolic blood pressure measurement, in {@link android.health.connect.datatypes.units.Pressure Pressure} unit. Required
 *     field. Valid range: 20-200 mmHg.
 * This value cannot be {@code null}.
 * @param diastolic Diastolic blood pressure measurement, in {@link android.health.connect.datatypes.units.Pressure Pressure} unit. Required
 *     field. Valid range: 10-180 mmHg.
 * This value cannot be {@code null}.
 * @param bodyPosition The user's body position when the measurement was taken. Optional
 *     field. Allowed values: {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition BodyPosition}.

 * Value is {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_UNKNOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_STANDING_UP}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_SITTING_DOWN}, {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_LYING_DOWN}, or {@link android.health.connect.datatypes.BloodPressureRecord.BodyPosition#BODY_POSITION_RECLINING}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int measurementLocation, @android.annotation.NonNull android.health.connect.datatypes.units.Pressure systolic, @android.annotation.NonNull android.health.connect.datatypes.units.Pressure diastolic, int bodyPosition) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.BloodPressureRecord BloodPressureRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord build() { throw new RuntimeException("Stub!"); }
}

}

