/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/**
 * Captures exercise or a sequence of exercises. This can be a playing game like football or a
 * sequence of fitness exercises.
 *
 * <p>Each record needs a start time, end time and session type. In addition, each record has two
 * optional independent lists of time intervals: {@link android.health.connect.datatypes.ExerciseSegment ExerciseSegment} represents particular
 * exercise within session, {@link android.health.connect.datatypes.ExerciseLap ExerciseLap} represents a lap time within session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseSessionRecord extends android.health.connect.datatypes.IntervalRecord {

ExerciseSessionRecord() { throw new RuntimeException("Stub!"); }

/**
 * Returns exerciseType of this session.
 * @return Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 */

public int getExerciseType() { throw new RuntimeException("Stub!"); }

/** Returns notes for this activity. Returns null if the session doesn't have notes. */

@android.annotation.Nullable
public java.lang.CharSequence getNotes() { throw new RuntimeException("Stub!"); }

/** Returns title of this session. Returns null if the session doesn't have title. */

@android.annotation.Nullable
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

/** Returns route of this session. Returns null if the session doesn't have route. */

@android.annotation.Nullable
public android.health.connect.datatypes.ExerciseRoute getRoute() { throw new RuntimeException("Stub!"); }

/**
 * Returns segments of this session. Returns empty list if the session doesn't have exercise
 * segments.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.ExerciseSegment> getSegments() { throw new RuntimeException("Stub!"); }

/**
 * Returns laps of this session. Returns empty list if the session doesn't have exercise laps.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.ExerciseLap> getLaps() { throw new RuntimeException("Stub!"); }

/**
 * Returns if this session has recorded route.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public boolean hasRoute() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to retrieve total exercise session duration using aggregate APIs in {@link
 * android.health.connect.HealthConnectManager}. Calculated in milliseconds.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> EXERCISE_DURATION_TOTAL;
static { EXERCISE_DURATION_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.ExerciseSessionRecord ExerciseSessionRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity
 * This value cannot be {@code null}.
 * @param exerciseType Type of exercise (e.g. walking, swimming). Required field. Allowed
 *     values: {@link android.health.connect.datatypes.ExerciseSessionType ExerciseSessionType}

 * Value is {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BADMINTON}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASEBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BASKETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BIKING_STATIONARY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOOT_CAMP}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_BOXING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CALISTHENICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_CRICKET}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_DANCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ELLIPTICAL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_EXERCISE_CLASS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FENCING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AMERICAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FOOTBALL_AUSTRALIAN}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_FRISBEE_DISC}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GOLF}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GUIDED_BREATHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_GYMNASTICS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HANDBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_HIKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ICE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_MARTIAL_ARTS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PADDLING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PARAGLIDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_PILATES}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RACQUETBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROCK_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROLLER_HOCKEY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_ROWING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUGBY}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_RUNNING_TREADMILL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SAILING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SCUBA_DIVING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKATING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SKIING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWBOARDING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SNOWSHOEING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOCCER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SOFTBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SQUASH}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STAIR_CLIMBING_MACHINE}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRENGTH_TRAINING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_STRETCHING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SURFING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_OPEN_WATER}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_SWIMMING_POOL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TABLE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_TENNIS}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_VOLLEYBALL}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WALKING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WATER_POLO}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WEIGHTLIFTING}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_WHEELCHAIR}, {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_OTHER_WORKOUT}, or {@link android.health.connect.datatypes.ExerciseSessionType#EXERCISE_SESSION_TYPE_YOGA}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, int exerciseType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the session started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the session ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets notes for this activity
 *
 * @param notes Notes for this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setNotes(@android.annotation.Nullable java.lang.CharSequence notes) { throw new RuntimeException("Stub!"); }

/**
 * Sets a title of this activity
 *
 * @param title Title of this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

/**
 * Sets route for this activity
 *
 * @param route ExerciseRoute for this activity
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setRoute(@android.annotation.Nullable android.health.connect.datatypes.ExerciseRoute route) { throw new RuntimeException("Stub!"); }

/**
 * Sets segments for this session.
 *
 * @param laps list of {@link android.health.connect.datatypes.ExerciseLap ExerciseLap} of this session
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setLaps(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.ExerciseLap> laps) { throw new RuntimeException("Stub!"); }

/**
 * Sets segments for this session.
 *
 * @param segments list of {@link android.health.connect.datatypes.ExerciseSegment ExerciseSegment} of this session
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord.Builder setSegments(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.ExerciseSegment> segments) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.health.connect.datatypes.ExerciseSessionRecord ExerciseSessionRecord}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.ExerciseSessionRecord build() { throw new RuntimeException("Stub!"); }
}

}

